/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.feature;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.block.TallDunegrassBlock;
import dev.hybridlabs.aquatic.block.wood.HybridAquaticPlatformBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/DunegrassFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/ProbabilityFeatureConfiguration;", "codec", "Lcom/mojang/serialization/Codec;", "<init>", "(Lcom/mojang/serialization/Codec;)V", "place", "", "context", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "hybrid-aquatic-neoforge-1.21.1"})
public final class DunegrassFeature
extends Feature<ProbabilityFeatureConfiguration> {
    public DunegrassFeature(@NotNull Codec<ProbabilityFeatureConfiguration> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        boolean placed = false;
        RandomSource random = context.random();
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        ProbabilityFeatureConfiguration config = (ProbabilityFeatureConfiguration)context.config();
        int dx = random.nextInt(8) - random.nextInt(8);
        int dz = random.nextInt(8) - random.nextInt(8);
        int posY = world.getHeight(Heightmap.Types.WORLD_SURFACE, origin.getX() + dx, origin.getZ() + dz);
        BlockPos pos = new BlockPos(origin.getX() + dx, posY, origin.getZ() + dz);
        if (posY > world.getSeaLevel() + 2 && world.isEmptyBlock(pos)) {
            boolean blTall;
            boolean bl = blTall = random.nextDouble() < (double)config.probability;
            if (blTall) {
                BlockState lower = (BlockState)HybridAquaticPlatformBlocks.INSTANCE.getTALL_DUNEGRASS().get().defaultBlockState().setValue((Property)TallDunegrassBlock.Companion.getHALF(), (Comparable)DoubleBlockHalf.LOWER);
                BlockState upper = (BlockState)HybridAquaticPlatformBlocks.INSTANCE.getTALL_DUNEGRASS().get().defaultBlockState().setValue((Property)TallDunegrassBlock.Companion.getHALF(), (Comparable)DoubleBlockHalf.UPPER);
                if (pos.getY() < world.getMaxBuildHeight() - 1 && world.isEmptyBlock(pos.above()) && lower.canSurvive((LevelReader)world, pos)) {
                    world.setBlock(pos, lower, 2);
                    world.setBlock(pos.above(), upper, 2);
                    placed = true;
                }
            } else {
                BlockState blockState = HybridAquaticPlatformBlocks.INSTANCE.getDUNEGRASS().get().defaultBlockState();
                if (blockState.canSurvive((LevelReader)world, pos)) {
                    world.setBlock(pos, blockState, 2);
                    placed = true;
                }
            }
        }
        return placed;
    }
}

