/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet;

import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.IRendererWithModel;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class GauntletEnergyRenderer
implements IRendererWithModel,
IRenderer<GauntletEntity> {
    private final GeoModel<GauntletEntity> geoModel;
    private final EntityRendererProvider.Context context;
    private final ResourceLocation armorTexture = ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"textures/entity/obsidilith_armor.png");
    private RenderHelper geoModelProvider;
    private GauntletEntity gauntletEntity;
    private RenderType type;

    public GauntletEnergyRenderer(GeoModel<GauntletEntity> geoModel, EntityRendererProvider.Context context) {
        this.geoModel = geoModel;
        this.context = context;
    }

    @Override
    public void render(GauntletEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        float renderAge = (float)entity.tickCount + partialTicks;
        float textureOffset = renderAge * 0.01f;
        if (this.geoModelProvider == null) {
            this.geoModelProvider = new RenderHelper(entity, this.geoModel, this.context);
        }
        this.gauntletEntity = entity;
        this.type = RenderType.energySwirl((ResourceLocation)this.armorTexture, (float)textureOffset, (float)textureOffset);
    }

    @Override
    public void render(BakedGeoModel model, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        VertexConsumer energyBuffer = buffer.getBuffer(this.type);
        if (this.gauntletEntity == null) {
            return;
        }
        if (this.type == null) {
            return;
        }
        float renderAlpha = this.gauntletEntity.energyShieldHandler.getRenderAlpha();
        if (renderAlpha == 0.0f) {
            return;
        }
        float lerpedAlpha = Mth.lerp((float)partialTicks, (float)(renderAlpha - 0.1f), (float)renderAlpha);
        int colour = FastColor.ARGB32.colorFromFloat((float)lerpedAlpha, (float)(0.8f * lerpedAlpha), (float)(0.2f * lerpedAlpha), (float)(0.2f * lerpedAlpha));
        if (this.geoModelProvider == null) {
            return;
        }
        this.geoModelProvider.actuallyRender(poseStack, (Entity)this.gauntletEntity, model, this.type, buffer, energyBuffer, false, partialTicks, packedLightIn, OverlayTexture.NO_OVERLAY, colour);
    }

    private static class RenderHelper
    extends GeoEntityRenderer<GauntletEntity> {
        private final GauntletEntity gauntletEntity;

        public RenderHelper(GauntletEntity gauntletEntity, GeoModel<GauntletEntity> parentModel, EntityRendererProvider.Context context) {
            super(context, parentModel);
            this.gauntletEntity = gauntletEntity;
        }

        public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
            poseStack.pushPose();
            poseStack.scale(1.1f, 1.05f, 1.1f);
            super.renderCube(poseStack, cube, buffer, 0xF000F0, packedOverlay, colour);
            poseStack.popPose();
        }

        public GauntletEntity getAnimatable() {
            return this.gauntletEntity;
        }
    }
}

