/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.item.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.block.custom.ChiseledStoneAltarBlock;
import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.spawn.CompoundTagEntityProvider;
import com.cerbon.bosses_of_mass_destruction.entity.spawn.HorizontalRangedSpawnPosition;
import com.cerbon.bosses_of_mass_destruction.entity.spawn.MobEntitySpawnPredicate;
import com.cerbon.bosses_of_mass_destruction.entity.spawn.MobPlacementLogic;
import com.cerbon.bosses_of_mass_destruction.entity.spawn.SimpleMobSpawner;
import com.cerbon.bosses_of_mass_destruction.item.custom.SoulStarEntity;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.structure.BMDStructures;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SoulStarItem
extends Item {
    public SoulStarItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.bosses_of_mass_destruction.soul_star.tooltip").withStyle(ChatFormatting.DARK_GRAY));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        if (blockState.is((Block)BMDBlocks.CHISELED_STONE_ALTAR.get()) && !((Boolean)blockState.getValue((Property)ChiseledStoneAltarBlock.lit)).booleanValue()) {
            if (level.isClientSide()) {
                this.clientSoulStartPlace(blockPos);
                return InteractionResult.SUCCESS;
            }
            this.serverSoulStarPlace(blockState, level, blockPos, context);
            level.playSound(null, context.getClickLocation().x, context.getClickLocation().y, context.getClickLocation().z, (SoundEvent)BMDSounds.SOUL_STAR.get(), SoundSource.NEUTRAL, 0.5f, SoundUtils.randomPitch((RandomSource)level.random));
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private void serverSoulStarPlace(BlockState blockState, Level level, BlockPos blockPos, UseOnContext context) {
        BlockState blockState2 = (BlockState)blockState.setValue((Property)ChiseledStoneAltarBlock.lit, (Comparable)Boolean.valueOf(true));
        level.setBlock(blockPos, blockState2, 2);
        context.getItemInHand().shrink(1);
        List<BlockPos> quarterAltarPosition = List.of(new BlockPos(12, 0, 0), new BlockPos(6, 0, 6));
        List allPotentialAltarPositions = Arrays.stream(Rotation.values()).flatMap(rot -> quarterAltarPosition.stream().map(blockPos1 -> blockPos1.rotate(rot))).toList();
        int numberOfAltarsFilled = (int)allPotentialAltarPositions.stream().filter(pos -> {
            BlockState state = level.getBlockState(blockPos.offset((Vec3i)pos));
            return state.hasProperty((Property)ChiseledStoneAltarBlock.lit) && (Boolean)state.getValue((Property)ChiseledStoneAltarBlock.lit) != false;
        }).count();
        if (numberOfAltarsFilled == 3) {
            EventScheduler eventScheduler = CapabilityUtils.getLevelEventScheduler((Level)level);
            eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                allPotentialAltarPositions.forEach(blockPos1 -> {
                    if (level.getBlockState(blockPos.offset((Vec3i)blockPos1)).hasProperty((Property)ChiseledStoneAltarBlock.lit)) {
                        level.destroyBlock(blockPos.offset((Vec3i)blockPos1), false);
                    }
                });
                level.destroyBlock(blockPos, false);
                this.spawnLich(blockPos, level);
            }, 20));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSoulStartPlace(BlockPos blockPos) {
        Vec3 centralPos = VecUtils.asVec3((BlockPos)blockPos).add(new Vec3(0.5, 1.2, 0.5));
        MathUtils.circleCallback((double)0.5, (int)15, (Vec3)VecUtils.yAxis, vec3 -> {
            Vec3 particleVel = VecUtils.yAxis.scale(0.03 + RandomUtils.randDouble((double)0.01));
            Vec3 particlePos = centralPos.add(vec3);
            ChiseledStoneAltarBlock.Particles.blueFireParticleFactory.build(particlePos, particleVel);
        });
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        BlockHitResult hitResult = SoulStarItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult.getType() == HitResult.Type.BLOCK && level.getBlockState(hitResult.getBlockPos()).is((Block)BMDBlocks.CHISELED_STONE_ALTAR.get())) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        player.startUsingItem(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = serverLevel.findNearestMapStructure(BMDStructures.SOUL_STAR_STRUCTURE_KEY, player.blockPosition(), 100, false);
            if (blockPos != null) {
                SoulStarEntity entity = new SoulStarEntity(level, player.getX(), player.getEyeY(), player.getZ());
                entity.setItem(itemStack);
                entity.initTargetPos(blockPos);
                level.addFreshEntity((Entity)entity);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 0.5f, 0.4f / level.getRandom().nextFloat() * 0.4f + 0.8f);
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                player.swing(usedHand, true);
                return InteractionResultHolder.success((Object)itemStack);
            }
            return InteractionResultHolder.pass((Object)itemStack);
        }
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void spawnLich(BlockPos blockPos, Level level) {
        LichEntity entity;
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("id", ResourceLocation.fromNamespaceAndPath((String)"bosses_of_mass_destruction", (String)"lich").toString());
        Vec3 spawnPos = VecUtils.asVec3((BlockPos)blockPos);
        boolean spawned = new MobPlacementLogic(new HorizontalRangedSpawnPosition(spawnPos, 15.0, 30.0), new CompoundTagEntityProvider(compoundTag, level), new MobEntitySpawnPredicate((LevelReader)level), new SimpleMobSpawner((ServerLevel)level)).tryPlacement(200);
        if (!spawned && (entity = (LichEntity)((EntityType)BMDEntities.LICH.get()).create(level)) != null) {
            Vec3 defaultSpawnPos = spawnPos.add(VecUtils.xAxis.scale(5.0));
            entity.syncPacketPositionCodec(defaultSpawnPos.x, defaultSpawnPos.y, defaultSpawnPos.z);
            entity.absMoveTo(defaultSpawnPos.x, defaultSpawnPos.y, defaultSpawnPos.z);
            level.addFreshEntity((Entity)entity);
        }
    }
}

