/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.packet.custom;

import com.cerbon.cerbons_api.api.network.data.PacketContext;
import com.cerbon.cerbons_api.api.network.data.Side;
import com.cerbon.cerbons_api.api.static_utilities.PacketUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class SendDeltaMovementS2CPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"cerbons_api", (String)"send_delta_movement_s2c_packet");
    public static final StreamCodec<FriendlyByteBuf, SendDeltaMovementS2CPacket> STREAM_CODEC = StreamCodec.ofMember(SendDeltaMovementS2CPacket::write, SendDeltaMovementS2CPacket::new);
    private final Vec3 deltaMovement;

    public SendDeltaMovementS2CPacket(Vec3 deltaMovement) {
        this.deltaMovement = deltaMovement;
    }

    public SendDeltaMovementS2CPacket(FriendlyByteBuf buf) {
        this.deltaMovement = PacketUtils.readVec3((FriendlyByteBuf)buf);
    }

    public void write(FriendlyByteBuf buf) {
        PacketUtils.writeVec3((FriendlyByteBuf)buf, (Vec3)this.deltaMovement);
    }

    public static void handle(PacketContext<SendDeltaMovementS2CPacket> ctx) {
        if (ctx.side().equals((Object)Side.SERVER)) {
            return;
        }
        SendDeltaMovementS2CPacket packet = (SendDeltaMovementS2CPacket)ctx.message();
        Minecraft client = Minecraft.getInstance();
        LocalPlayer localPlayer = client.player;
        if (localPlayer == null) {
            return;
        }
        client.execute(() -> localPlayer.setDeltaMovement(packet.deltaMovement));
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }
}

