/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern;

import com.cerbon.bosses_of_mass_destruction.structure.util.IStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.ICaveDecorator;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class MossCeilingCaveDecorator
implements ICaveDecorator {
    private final int bottomOfWorld;
    private final RandomSource random;
    private final List<BlockPos> mossCeilingPositions = new ArrayList<BlockPos>();

    public MossCeilingCaveDecorator(int bottomOfWorld, RandomSource random) {
        this.bottomOfWorld = bottomOfWorld;
        this.random = random;
    }

    @Override
    public void onBlockPlaced(BlockPos pos, Block block) {
        if (pos.getY() > 18 + this.bottomOfWorld && this.random.nextInt(20) == 0 && block != Blocks.AIR) {
            this.mossCeilingPositions.add(pos);
        }
    }

    @Override
    public void generate(WorldGenLevel level, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, BlockPos pos, IStructurePiece structurePiece) {
        Map<Pair, List<BlockPos>> groupedMossCeilingPositions = this.mossCeilingPositions.stream().collect(Collectors.groupingBy(p -> new Pair((Object)(p.getX() >> 3), (Object)(p.getZ() >> 3))));
        List<BlockPos> spacedMossCeilingPositions = groupedMossCeilingPositions.values().stream().map(list -> (BlockPos)list.get(0)).toList();
        for (BlockPos mossPoss : spacedMossCeilingPositions) {
            if (!boundingBox.isInside((Vec3i)mossPoss)) continue;
            BMDUtils.getConfiguredFeature((LevelReader)level, CaveFeatures.MOSS_PATCH_CEILING).place(level, chunkGenerator, random, mossPoss);
        }
    }
}

