/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern;

import com.cerbon.bosses_of_mass_destruction.structure.util.IPieceGenerator;
import com.cerbon.bosses_of_mass_destruction.structure.util.IStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.BossBlockDecorator;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.ICaveDecorator;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.MossCeilingCaveDecorator;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.MossFloorCaveDecorator;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.SpikeCaveDecorator;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.SporeBlossomCaveDecorator;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class VoidBlossomCavernPieceGenerator
implements IPieceGenerator {
    @Override
    public void generate(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos, IStructurePiece structurePiece) {
        int minY = chunkGenerator.getMinY();
        List<ICaveDecorator> caveDecorators = Arrays.asList(new SpikeCaveDecorator(minY, random), new MossFloorCaveDecorator(minY, random), new MossCeilingCaveDecorator(minY, random), new SporeBlossomCaveDecorator(minY, random), new BossBlockDecorator(minY));
        this.generateCave(level, pos.above(17), structurePiece, random, boundingBox, caveDecorators, chunkGenerator.getMinY());
        for (ICaveDecorator caveDecorator : caveDecorators) {
            caveDecorator.generate(level, chunkGenerator, random, boundingBox, pos, structurePiece);
        }
    }

    private void generateCave(WorldGenLevel level, BlockPos pos, IStructurePiece structurePiece, RandomSource random, BoundingBox boundingBox, List<ICaveDecorator> caveDecorators, int bottomOfWorld) {
        double noiseMultiplier = 0.005;
        UniformInt outerWallDistance = UniformInt.of((int)3, (int)4);
        UniformInt pointOffset = UniformInt.of((int)1, (int)2);
        int minY = bottomOfWorld - pos.getY();
        int maxY = minY + 32;
        int minXZ = -32;
        int maxXZ = 32;
        double verticalSquish = 2.0;
        int distributionPoints = 5;
        LinkedList<Pair> randoms = new LinkedList<Pair>();
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.getSeed()));
        NormalNoise normalNoise = NormalNoise.create((RandomSource)worldgenRandom, (int)-4, (double[])new double[]{1.0});
        double d = (double)distributionPoints / (double)outerWallDistance.getMaxValue();
        double airThickness = 1.0 / Math.sqrt(25.2 + d);
        double outerLayerThickness = 1.0 / Math.sqrt(30.2 + d);
        for (int r = 0; r < distributionPoints; ++r) {
            BlockPos randomPos = pos.offset(outerWallDistance.sample(random), outerWallDistance.sample(random), outerWallDistance.sample(random));
            randoms.add(Pair.of((Object)randomPos, (Object)pointOffset.sample(random)));
        }
        Predicate predicate = Feature.isReplaceable((TagKey)BlockTags.FEATURES_CANNOT_REPLACE);
        Iterator positions = BlockPos.betweenClosed((BlockPos)pos.offset(minXZ, minY, minXZ), (BlockPos)pos.offset(maxXZ, maxY, maxXZ)).iterator();
        while (positions.hasNext()) {
            BlockPos samplePos = (BlockPos)positions.next();
            double noise = normalNoise.getValue((double)samplePos.getX(), (double)samplePos.getY(), (double)samplePos.getZ()) * noiseMultiplier;
            double noisedDistance = 0.0;
            for (Pair pair : randoms) {
                BlockPos distancePos = new BlockPos(samplePos.getX(), (int)((double)(samplePos.getY() - bottomOfWorld) * verticalSquish + (double)bottomOfWorld), samplePos.getZ());
                noisedDistance += Mth.fastInvSqrt((double)(distancePos.distSqr((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + noise;
            }
            if (noisedDistance < outerLayerThickness) continue;
            BlockPos finalSamplePos = samplePos;
            Supplier<Boolean> canReplace = () -> predicate.test(level.getBlockState(finalSamplePos)) && !level.getBlockState(finalSamplePos).isAir() && level.getBlockState(finalSamplePos).getBlock() != Blocks.BEDROCK && finalSamplePos.getY() > 4 + bottomOfWorld;
            if (noisedDistance >= airThickness) {
                this.replaceBlock(canReplace, level, samplePos, structurePiece, boundingBox, Blocks.AIR.defaultBlockState(), caveDecorators);
                continue;
            }
            if (!(noisedDistance >= outerLayerThickness)) continue;
            this.replaceBlock(canReplace, level, samplePos, structurePiece, boundingBox, samplePos.getY() > 0 ? Blocks.STONE.defaultBlockState() : Blocks.DEEPSLATE.defaultBlockState(), caveDecorators);
        }
        return;
    }

    private void replaceBlock(Supplier<Boolean> predicate, WorldGenLevel level, BlockPos samplePos, IStructurePiece structurePiece, BoundingBox boundingBox, BlockState blockState, List<ICaveDecorator> caveDecorators) {
        if (predicate.get().booleanValue()) {
            structurePiece.placeBlock(level, blockState, samplePos, boundingBox);
        }
        for (ICaveDecorator decorator : caveDecorators) {
            decorator.onBlockPlaced(new BlockPos((Vec3i)samplePos), blockState.getBlock());
        }
    }
}

