/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import fr.iglee42.createqualityoflife.behaviours.EnderPackagerBehaviour;
import fr.iglee42.createqualityoflife.blocks.EnderPackagerBlock;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.utils.EnderPackagerFrequencySlot;
import fr.iglee42.createqualityoflife.utils.EnderPackagerItemHandler;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.commons.lang3.tuple.Pair;

public class EnderPackagerBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private EnderPackagerBehaviour link;
    private boolean transmitter;
    public ItemStack heldBox = ItemStack.EMPTY;
    public final EnderPackagerItemHandler inventory = new EnderPackagerItemHandler(this);
    public static final int CYCLE = 20;
    public int animationTicks = 0;
    public boolean animationInward = true;
    public String addressFilter = "";

    public EnderPackagerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)QOLBlockEntities.ENDER_PACKAGER.get(), (be, context) -> be.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair slots = ValueBoxTransform.Dual.makeSlots(EnderPackagerFrequencySlot::new);
        this.link = this.transmitter ? EnderPackagerBehaviour.transmitter(this, (Pair<ValueBoxTransform, ValueBoxTransform>)slots) : EnderPackagerBehaviour.receiver(this, (Pair<ValueBoxTransform, ValueBoxTransform>)slots, () -> this.inventory);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Transmitter", this.transmitter);
        compound.putInt("Receive", this.getReceivedSignal());
        compound.putBoolean("ReceivedChanged", this.receivedSignalChanged);
        compound.putInt("Transmit", this.transmittedSignal);
        super.write(compound, registries, clientPacket);
        compound.putBoolean("AnimationInward", this.animationInward);
        compound.putInt("AnimationTicks", this.animationTicks);
        compound.put("HeldBox", this.heldBox.saveOptional(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.transmitter = compound.getBoolean("Transmitter");
        super.read(compound, registries, clientPacket);
        this.animationInward = compound.getBoolean("AnimationInward");
        this.animationTicks = compound.getInt("AnimationTicks");
        this.heldBox = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("HeldBox"));
        this.receivedSignal = compound.getInt("Receive");
        this.receivedSignalChanged = compound.getBoolean("ReceivedChanged");
        if (this.level == null || this.level.isClientSide || !this.link.newPosition) {
            this.transmittedSignal = compound.getInt("Transmit");
        }
    }

    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            EnderPackagerBehaviour prevlink = this.link;
            this.removeBehaviour(EnderPackagerBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.animationTicks == 0) {
            return;
        }
        if (this.level.isClientSide) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                AllSoundEvents.PACKAGER.playAt(this.level, (Vec3i)this.worldPosition, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.level.playLocalSound(this.worldPosition, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.level.isClientSide()) {
            if (!this.isTransmitter()) {
                this.wakeTheFrogs();
            } else {
                this.sendPackage();
            }
            this.setChanged();
        }
    }

    private void sendPackage() {
        if (this.heldBox.isEmpty()) {
            return;
        }
        ((EnderPackagerBehaviour)this.getBehaviour(EnderPackagerBehaviour.TYPE)).sendPackage(this.heldBox);
        this.inventory.extractItem(0, 64, false);
    }

    protected void wakeTheFrogs() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(Direction.UP));
        if (blockEntity instanceof FrogportBlockEntity) {
            FrogportBlockEntity port = (FrogportBlockEntity)blockEntity;
            port.tryPullingFromOwnAndAdjacentInventories();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.transmitter) {
            this.updateSignAddress();
            return;
        }
        this.attemptToSend();
    }

    public void attemptToSend() {
        if (this.heldBox.isEmpty() || this.animationTicks != 0) {
            return;
        }
        if (!((EnderPackagerBehaviour)this.getBehaviour(EnderPackagerBehaviour.TYPE)).canSendPackage(this.heldBox)) {
            return;
        }
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
    }

    public void remove() {
        super.remove();
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = Mth.clamp((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public ItemStack getRenderedBox() {
        if (this.animationTicks == 0) {
            return this.heldBox;
        }
        if (this.animationInward) {
            return this.animationTicks <= 10 ? ItemStack.EMPTY : this.heldBox;
        }
        return this.animationTicks >= 10 ? ItemStack.EMPTY : this.heldBox;
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.getBlockState().getValue((Property)EnderPackagerBlock.POWERED) == false;
    }

    public boolean isTransmitter() {
        return this.transmitter;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }

    public boolean doesMatchAddress(ItemStack stack) {
        return this.addressFilter.isBlank() || PackageItem.matchAddress((ItemStack)stack, (String)this.addressFilter);
    }

    public void receivedBox() {
        if (this.heldBox.isEmpty() || this.animationTicks != 0) {
            return;
        }
        this.animationInward = false;
        this.animationTicks = 20;
        this.notifyUpdate();
    }

    protected void updateSignAddress() {
        this.addressFilter = "";
        for (Direction side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.addressFilter = address;
        }
    }

    protected String getSign(Direction side) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity sign = (SignBlockEntity)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            SignText text = sign.getText(front);
            Object address = "";
            for (Component component : text.getMessages(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }
}

