/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelModeSlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLIcons;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;

public class InventoryLinkerBlockEntity
extends KineticBlockEntity {
    private ItemStack playerPaperItemStack = ItemStack.EMPTY;
    private UUID linkedPlayer;
    protected ScrollOptionBehaviour<Mode> selectionMode;

    public InventoryLinkerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)QOLBlockEntities.INVENTORY_LINKER.get(), (be, context) -> {
            if (context != Direction.DOWN) {
                return be.getPlayerInventory(be.getLevel());
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour(Mode.class, (Component)CreateLang.translateDirect((String)"options.inventory_linker.label", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new BrassTunnelModeSlot());
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
    }

    public UUID getLinkedPlayer() {
        return this.linkedPlayer;
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.isSpeedRequirementFulfilled()) {
            return;
        }
        this.linkedPlayer = !this.playerPaperItemStack.isEmpty() ? (UUID)this.playerPaperItemStack.get(QOLDataComponents.LINKED_PLAYER) : null;
    }

    public void write(CompoundTag tag, HolderLookup.Provider provider, boolean clientPacket) {
        super.write(tag, provider, clientPacket);
        tag.putInt("mode", this.selectionMode.getValue());
        tag.put("paper", this.playerPaperItemStack.saveOptional(provider));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider provider, boolean clientPacket) {
        super.read(compound, provider, clientPacket);
        this.selectionMode.setValue(compound.getInt("mode"));
        this.playerPaperItemStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("paper"));
    }

    public void setPlayerPaperItemStack(ItemStack playerPaperItemStack) {
        this.playerPaperItemStack = playerPaperItemStack;
    }

    public ItemStack getPlayerPaperItemStack() {
        return this.playerPaperItemStack;
    }

    public void remove() {
        super.remove();
        Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)this.playerPaperItemStack);
    }

    public IItemHandler getPlayerInventory(Level level) {
        if (this.linkedPlayer != null && level.getPlayerByUUID(this.linkedPlayer) != null) {
            return switch (((Mode)this.selectionMode.get()).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new PlayerMainInvWrapper(level.getPlayerByUUID(this.linkedPlayer).getInventory());
                case 1 -> new PlayerArmorInvWrapper(level.getPlayerByUUID(this.linkedPlayer).getInventory());
                case 2 -> new PlayerOffhandInvWrapper(level.getPlayerByUUID(this.linkedPlayer).getInventory());
            };
        }
        return new ItemStackHandler(0);
    }

    public static enum Mode implements INamedIconOptions
    {
        INVENTORY(0, 36, QOLIcons.I_INVENTORY),
        ARMOR(1, 4, QOLIcons.I_ARMOR),
        OFF_HAND(2, 1, QOLIcons.I_OFF_HAND);

        private int id;
        private int slotCount;
        private AllIcons icon;

        private Mode(int id, int slotCount, AllIcons icon) {
            this.id = id;
            this.slotCount = slotCount;
            this.icon = icon;
        }

        public int getSlotCount() {
            return this.slotCount;
        }

        public int getId() {
            return this.id;
        }

        public static Mode getById(int id) {
            return Arrays.stream(Mode.values()).filter(m -> m.getId() == id).findFirst().orElse(INVENTORY);
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "options.inventory_linker." + this.name().toLowerCase();
        }
    }
}

