/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import fr.iglee42.createqualityoflife.blocks.ShadowRadianceBacktankBlock;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShadowRadianceBacktankBE
extends BacktankBlockEntity {
    private boolean propeller;
    private boolean fans;
    private boolean hover;
    private boolean elytra;

    public ShadowRadianceBacktankBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setPropeller(boolean propeller) {
        this.propeller = propeller;
    }

    public void setFans(boolean fans) {
        this.fans = fans;
    }

    public void setHover(boolean hover) {
        this.hover = hover;
    }

    public void setElytra(boolean elytra) {
        this.elytra = elytra;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider provider, boolean clientPacket) {
        super.write(compound, provider, clientPacket);
        compound.putBoolean("propeller", this.propeller);
        compound.putBoolean("fans", this.fans);
        compound.putBoolean("hover", this.hover);
        compound.putBoolean("elytra", this.elytra);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider provider, boolean clientPacket) {
        super.read(compound, provider, clientPacket);
        this.propeller = compound.getBoolean("propeller");
        this.fans = compound.getBoolean("fans");
        this.hover = compound.getBoolean("hover");
        this.elytra = compound.getBoolean("elytra");
    }

    public boolean hasPropeller() {
        return this.propeller;
    }

    public boolean isFans() {
        return this.fans;
    }

    public boolean isHover() {
        return this.hover;
    }

    public boolean hasElytra() {
        return this.elytra;
    }

    public void tick() {
        super.tick();
        if ((Boolean)this.getBlockState().getValue((Property)ShadowRadianceBacktankBlock.PROPELLER) != this.propeller) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ShadowRadianceBacktankBlock.PROPELLER, (Comparable)Boolean.valueOf(this.propeller)));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.propeller = (Boolean)componentInput.getOrDefault(QOLDataComponents.BACKTANK_PROPELLERS, (Object)false);
        this.fans = (Boolean)componentInput.getOrDefault(QOLDataComponents.BACKTANK_FANS, (Object)true);
        this.hover = (Boolean)componentInput.getOrDefault(QOLDataComponents.BACKTANK_HOVER, (Object)false);
        this.elytra = (Boolean)componentInput.getOrDefault(QOLDataComponents.BACKTANK_ELYTRA, (Object)false);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(QOLDataComponents.BACKTANK_PROPELLERS, (Object)this.propeller);
        components.set(QOLDataComponents.BACKTANK_FANS, (Object)this.fans);
        components.set(QOLDataComponents.BACKTANK_HOVER, (Object)this.hover);
        components.set(QOLDataComponents.BACKTANK_ELYTRA, (Object)this.elytra);
    }
}

