/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.registries.QOLPartialModels;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class StockManagerRenderer
extends SafeBlockEntityRenderer<StockManagerBlockEntity> {
    public StockManagerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(StockManagerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!be.hasBlazeFromBlock()) {
            return;
        }
        Level level = be.getLevel();
        BlockState blockState = be.getBlockState();
        float animation = be.headAnimation.getValue(partialTicks) * 0.175f;
        float horizontalAngle = AngleHelper.rad((double)be.headAngle.getValue(partialTicks));
        PartialModel drawHat = AllPartialModels.LOGISTICS_HAT;
        int hashCode = ((Object)((Object)be)).hashCode();
        StockManagerRenderer.renderShared(ms, null, bufferSource, level, blockState, animation, horizontalAngle, drawHat, hashCode);
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource bufferSource, LerpedFloat headAngle, boolean conductor) {
        BlockState state = context.state;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf((BlockState)state);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            heatLevel = BlazeBurnerBlock.HeatLevel.FADING;
        }
        Level level = context.world;
        float horizontalAngle = AngleHelper.rad((double)headAngle.getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)level)));
        boolean drawGoggles = context.blockEntityData.contains("Goggles");
        boolean drawHat = conductor || context.blockEntityData.contains("TrainHat");
        int hashCode = context.hashCode();
        StockManagerRenderer.renderShared(matrices.getViewProjection(), matrices.getModel(), bufferSource, level, state, 0.0f, horizontalAngle, (PartialModel)(drawHat ? AllPartialModels.TRAIN_HAT : null), hashCode);
    }

    public static void renderShared(PoseStack ms, @Nullable PoseStack modelTransform, MultiBufferSource bufferSource, Level level, BlockState blockState, float animation, float horizontalAngle, PartialModel drawHat, int hashCode) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = 64.0f;
        float offset = Mth.sin((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        ms.pushPose();
        ms.translate(0.0f, 0.025f, 0.0f);
        PartialModel blazeModel = AllPartialModels.BLAZE_IDLE;
        SuperByteBuffer blazeBuffer = CachedBuffers.partial((PartialModel)blazeModel, (BlockState)blockState);
        if (modelTransform != null) {
            blazeBuffer.transform(modelTransform);
        }
        blazeBuffer.translate(0.0f, headY, 0.0f);
        StockManagerRenderer.draw(blazeBuffer, horizontalAngle, ms, bufferSource.getBuffer(RenderType.solid()));
        if (drawHat != null) {
            SuperByteBuffer hatBuffer = CachedBuffers.partial((PartialModel)drawHat, (BlockState)blockState);
            if (modelTransform != null) {
                hatBuffer.transform(modelTransform);
            }
            hatBuffer.translate(0.0f, headY, 0.0f);
            hatBuffer.translateY(0.75f);
            VertexConsumer cutout = bufferSource.getBuffer(RenderType.cutoutMipped());
            ((SuperByteBuffer)((SuperByteBuffer)hatBuffer.rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, 0.0f, 0.5f)).light(0xF000F0).renderInto(ms, cutout);
        }
        PartialModel rodsModel = QOLPartialModels.STOCK_MANAGER_RODS_1;
        PartialModel rodsModel2 = QOLPartialModels.STOCK_MANAGER_RODS_2;
        SuperByteBuffer rodsBuffer = CachedBuffers.partial((PartialModel)rodsModel, (BlockState)blockState);
        if (modelTransform != null) {
            rodsBuffer.transform(modelTransform);
        }
        ((SuperByteBuffer)rodsBuffer.translate(0.0f, offset1 + animation + 0.125f, 0.0f)).light(0xF000F0).renderInto(ms, bufferSource.getBuffer(RenderType.solid()));
        SuperByteBuffer rodsBuffer2 = CachedBuffers.partial((PartialModel)rodsModel2, (BlockState)blockState);
        if (modelTransform != null) {
            rodsBuffer2.transform(modelTransform);
        }
        ((SuperByteBuffer)rodsBuffer2.translate(0.0f, offset2 + animation - 0.1875f, 0.0f)).light(0xF000F0).renderInto(ms, bufferSource.getBuffer(RenderType.solid()));
        ms.popPose();
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack ms, VertexConsumer vc) {
        ((SuperByteBuffer)buffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(ms, vc);
    }
}

