/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenWithStencils;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.menus.StockManagerMenu;
import fr.iglee42.createqualityoflife.packets.DestroyLogisticsNetworkComponentPacket;
import fr.iglee42.createqualityoflife.packets.ModifyLogisticsNetworkPacket;
import fr.iglee42.createqualityoflife.packets.ModifyPlayerNetworkPermissionPacket;
import fr.iglee42.createqualityoflife.packets.OpenSwitchLogisticNetworkScreenPacket;
import fr.iglee42.createqualityoflife.packets.StockManagerDestructionLevelPacket;
import fr.iglee42.createqualityoflife.packets.StockManagerLockPacket;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import org.lwjgl.glfw.GLFW;

public class StockManagerScreen
extends AbstractSimiContainerScreen<StockManagerMenu>
implements ScreenWithStencils {
    private EditBox nameBox;
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;
    private static final QOLGuiTextures HEADER = QOLGuiTextures.STOCK_MANAGER_HEADER;
    private static final QOLGuiTextures UPPER_BODY = QOLGuiTextures.STOCK_MANAGER_UPPER_BODY;
    private static final QOLGuiTextures SEPARATION = QOLGuiTextures.STOCK_MANAGER_SEPARATION;
    private static final QOLGuiTextures LOWER_BODY = QOLGuiTextures.STOCK_MANAGER_LOWER_BODY;
    private static final QOLGuiTextures FOOTER = QOLGuiTextures.STOCK_MANAGER_FOOTER;
    StockManagerBlockEntity blockEntity;
    public LerpedFloat itemScroll;
    int lockX;
    int lockY;
    int destroyX;
    int destroyY;
    int switchX;
    int switchY;
    int windowWidth;
    int windowHeight;
    private boolean isAdmin;
    private boolean isOwner;
    private boolean isLocked;
    private String networkName;
    private int links;
    private List<LogisticallyLinkedBehaviour> behaviours;
    private NetworkDestructionLevel destructionLevel;
    private boolean mayDestroy;
    private boolean scrollHandleActive;
    private Map<UUID, NetworkPermission> permissions;
    private List<Rect2i> extraAreas = Collections.emptyList();
    public LerpedFloat blocksScroll = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat playersScroll = LerpedFloat.linear().startWithValue(0.0);
    private int lowerBodyStartY;
    private final Component clickToEdit = CreateQOLLang.translateDirect("gui.choose_network.lmb_manage", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public StockManagerScreen(StockManagerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.isAdmin = ((StockManagerMenu)this.menu).isAdmin;
        this.isOwner = ((StockManagerMenu)this.menu).isOwner;
        this.isLocked = ((StockManagerMenu)this.menu).isLocked;
        this.mayDestroy = ((StockManagerMenu)this.menu).mayDestroy;
        this.networkName = ((StockManagerMenu)this.menu).name;
        this.links = ((StockManagerMenu)this.menu).links;
        this.destructionLevel = ((StockManagerMenu)this.menu).destructionLevel;
        this.permissions = ((StockManagerMenu)this.menu).permissions.entrySet().stream().sorted((e1, e2) -> ((NetworkPermission)((Object)((Object)e2.getValue()))).ordinal() - ((NetworkPermission)((Object)((Object)e1.getValue()))).ordinal()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        this.blockEntity = (StockManagerBlockEntity)((Object)container.contentHolder);
        this.behaviours = new ArrayList<LogisticallyLinkedBehaviour>(LogisticallyLinkedBehaviour.getAllPresent((UUID)this.blockEntity.behaviour.freqId, (boolean)true, (boolean)true));
        this.behaviours.sort((a, b) -> {
            if (a.getPos().equals((Object)this.blockEntity.getBlockPos()) && !b.getPos().equals((Object)this.blockEntity.getBlockPos())) {
                return -1;
            }
            if (!a.getPos().equals((Object)this.blockEntity.getBlockPos()) && b.getPos().equals((Object)this.blockEntity.getBlockPos())) {
                return 1;
            }
            return 0;
        });
        this.itemScroll = LerpedFloat.linear().startWithValue(0.0);
    }

    protected void init() {
        int appropriateHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 10;
        appropriateHeight -= Mth.positiveModulo((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)LOWER_BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + LOWER_BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.init();
        this.clearWidgets();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.lockX = x + 184;
        this.lockY = y + 18;
        this.destroyX = this.lockX + 16;
        this.destroyY = y + 18;
        this.switchX = x + 25;
        this.switchY = y + 18;
        this.extraAreas = new ArrayList<Rect2i>();
        int leftHeight = 40;
        int rightHeight = 50;
        Consumer<String> onTextChanged = s -> this.nameBox.setX(this.nameBoxX((String)s, this.nameBox));
        this.nameBox = new EditBox((Font)new NoShadowFontWrapper(this.font), x + 10, y + 4, LOWER_BODY.getWidth() - 15 - 20, 10, (Component)Component.literal((String)this.networkName));
        this.nameBox.setBordered(false);
        this.nameBox.setMaxLength(40);
        this.nameBox.setTextColor(5841956);
        this.nameBox.setValue(this.networkName);
        this.nameBox.setFocused(false);
        this.nameBox.mouseClicked(0.0, 0.0, 0);
        this.nameBox.setResponder(onTextChanged);
        this.nameBox.setX(this.nameBoxX(this.nameBox.getValue(), this.nameBox));
        this.nameBox.setEditable(this.isOwner);
        this.addRenderableWidget((GuiEventListener)this.nameBox);
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.getGuiLeft() - 15 + LOWER_BODY.getWidth() / 2 - Math.min(this.font.width(s), nameBox.getWidth()) / 2;
    }

    protected void containerTick() {
        super.containerTick();
        this.blocksScroll.tickChaser();
        this.playersScroll.tickChaser();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack ms = guiGraphics.pose();
        ms.pushPose();
        ms.translate(0.0f, 0.0f, -300.0f);
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        ms.popPose();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i;
        if (this != this.minecraft.screen) {
            return;
        }
        PoseStack ms = graphics.pose();
        ms.pushPose();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        HEADER.render(graphics, x - 15, y);
        y += HEADER.getHeight();
        for (i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / UPPER_BODY.getHeight(); ++i) {
            UPPER_BODY.render(graphics, x - 15, y);
            y += UPPER_BODY.getHeight();
        }
        SEPARATION.render(graphics, x - 15, y);
        this.lowerBodyStartY = new AtomicInteger(y += SEPARATION.getHeight()).get();
        for (i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / LOWER_BODY.getHeight(); ++i) {
            LOWER_BODY.render(graphics, x - 15, y);
            y += LOWER_BODY.getHeight();
        }
        FOOTER.render(graphics, x - 15, y);
        y = this.getGuiTop();
        ms.pushPose();
        this.renderBehaviours(graphics, mouseX, mouseY, partialTicks);
        this.renderPlayers(graphics, mouseX, mouseY, partialTicks, this.lowerBodyStartY);
        ms.popPose();
        if (this.isAdmin) {
            (this.isLocked ? QOLGuiTextures.STOCK_MANAGER_LOCKED : QOLGuiTextures.STOCK_MANAGER_UNLOCKED).render(graphics, this.lockX, this.lockY);
        }
        if (this.isAdmin) {
            (switch (this.destructionLevel) {
                case NetworkDestructionLevel.MEMBERS -> QOLGuiTextures.STOCK_MANAGER_DESTRUCTION_MEMBERS;
                case NetworkDestructionLevel.ADMINS -> QOLGuiTextures.STOCK_MANAGER_DESTRUCTION_ADMINS;
                default -> QOLGuiTextures.STOCK_MANAGER_DESTRUCTION_ALLOW;
            }).render(graphics, this.destroyX, this.destroyY);
        }
        QOLGuiTextures.STOCK_MANAGER_SWITCH_NETWORK.render(graphics, this.switchX, this.switchY);
        String text = this.nameBox.getValue();
        if (!this.nameBox.isFocused() && this.isOwner) {
            QOLGuiTextures.STOCK_MANAGER_EDIT_NAME.render(graphics, this.nameBoxX(text, this.nameBox) + this.font.width(text) + 5, y + 1);
        }
        ms.popPose();
        this.endStencil();
    }

    protected void renderBehaviours(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.pose();
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.minecraft.getMainRenderTarget(), (RenderTarget)UIRenderHelper.framebuffer);
        int yOffset = this.getGuiTop() + HEADER.getHeight() - 8;
        float scrollOffset = -this.blocksScroll.getValue(partialTicks);
        for (int i = 0; i < this.behaviours.size(); ++i) {
            LogisticallyLinkedBehaviour entry = this.behaviours.get(i);
            this.startStencil(graphics, this.leftPos + 3, this.topPos + HEADER.getHeight(), 210.0f, (float)((this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / LOWER_BODY.getHeight()) * (float)UPPER_BODY.getHeight());
            matrixStack.pushPose();
            matrixStack.translate(0.0f, scrollOffset, 0.0f);
            int cardHeight = this.renderBehaviourEntry(graphics, i, entry, yOffset, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            matrixStack.popPose();
            this.endStencil();
        }
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.minecraft.getMainRenderTarget());
    }

    public int renderBehaviourEntry(GuiGraphics graphics, int i, LogisticallyLinkedBehaviour entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int cardWidth = 160;
        int cardHeader = 20;
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)(this.leftPos + 18), (float)(this.topPos + yOffset), 0.0f);
        QOLGuiTextures.CHOOSE_NETWORK_ENTRY.render(graphics, 0, 0);
        if (Minecraft.getInstance().hitResult != null && Minecraft.getInstance().player != null) {
            graphics.renderItem(Minecraft.getInstance().level.getBlockState(entry.getPos()).getCloneItemStack(Minecraft.getInstance().hitResult, (LevelReader)Minecraft.getInstance().level, entry.getPos(), (Player)Minecraft.getInstance().player), 10, 1);
        }
        MutableComponent name = Component.literal((String)entry.getPos().toShortString());
        graphics.drawString(this.font, name.getString(20).stripTrailing() + (name.getString(20).stripTrailing().length() > 20 ? "..." : ""), 30, 5, 0x656565, false);
        if (!entry.getPos().equals((Object)this.blockEntity.getBlockPos())) {
            (this.canDestroyEntry(entry) ? QOLGuiTextures.CHOOSE_NETWORK_DELETE : QOLGuiTextures.CHOOSE_NETWORK_DELETE_DISABLED).render(graphics, 171, 4);
        }
        matrixStack.popPose();
        return cardHeader;
    }

    private boolean canDestroyEntry(LogisticallyLinkedBehaviour behaviour) {
        return this.mayDestroy && Minecraft.getInstance().player.blockPosition().closerThan((Vec3i)behaviour.getPos(), (double)((Integer)CreateQOLConfigs.server().logistics.stockManagerMaxDestroyDistance.get()).intValue());
    }

    protected void renderPlayers(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, int lowerBodyStart) {
        PoseStack matrixStack = graphics.pose();
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.minecraft.getMainRenderTarget(), (RenderTarget)UIRenderHelper.framebuffer);
        int yOffset = lowerBodyStart;
        float scrollOffset = -this.playersScroll.getValue(partialTicks);
        ArrayList<Map.Entry<UUID, NetworkPermission>> entries = new ArrayList<Map.Entry<UUID, NetworkPermission>>(this.permissions.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            this.startStencil(graphics, this.leftPos + 3, lowerBodyStart, 210.0f, (float)((this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / LOWER_BODY.getHeight()) * (float)UPPER_BODY.getHeight());
            matrixStack.pushPose();
            matrixStack.translate(0.0f, scrollOffset, 0.0f);
            int cardHeight = this.renderPlayerEntry(graphics, i, (Map.Entry)entries.get(i), yOffset, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            matrixStack.popPose();
            this.endStencil();
        }
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.minecraft.getMainRenderTarget());
    }

    public int renderPlayerEntry(GuiGraphics graphics, int i, Map.Entry<UUID, NetworkPermission> entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int cardWidth = 160;
        int cardHeader = 20;
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)(this.leftPos + 18), (float)(this.topPos + yOffset), 0.0f);
        QOLGuiTextures.CHOOSE_NETWORK_ENTRY.render(graphics, 0, 0);
        if (Minecraft.getInstance().level != null) {
            ProfileResult result;
            MutableComponent playerName;
            MutableComponent mutableComponent = playerName = Minecraft.getInstance().player != null && Minecraft.getInstance().player.connection.getPlayerInfo(entry.getKey()) != null ? Component.literal((String)Minecraft.getInstance().player.connection.getPlayerInfo(entry.getKey()).getProfile().getName()) : Component.empty();
            if (playerName.equals((Object)Component.empty())) {
                ProfileResult result2 = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(entry.getKey(), false);
                playerName = result2 != null && result2.profile() != null ? Component.literal((String)result2.profile().getName()) : CreateQOLLang.translateDirect("gui.stock_manager.unknow_player", new Object[0]);
            }
            PlayerInfo info = Minecraft.getInstance().player.connection.getPlayerInfo(entry.getKey());
            boolean hasDrawn = false;
            if (info != null) {
                PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)info.getSkin(), (int)12, (int)3, (int)11);
                hasDrawn = true;
            }
            if (!hasDrawn && (result = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(entry.getKey(), false)) != null && result.profile() != null) {
                PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)Minecraft.getInstance().getSkinManager().getInsecureSkin(result.profile()), (int)12, (int)3, (int)11);
                hasDrawn = true;
            }
            if (!hasDrawn) {
                PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)DefaultPlayerSkin.get((UUID)entry.getKey()), (int)12, (int)3, (int)11);
            }
            graphics.drawString(this.font, playerName.getString(23).stripTrailing() + (playerName.getString().length() > 23 ? "..." : ""), 24, 5, 0x656565, false);
            graphics.drawString(this.font, (Component)CreateQOLLang.translateDirect("gui.stock_manager.permission." + entry.getValue().getSerializedName(), new Object[0]), 124, 5, 0x656565, false);
            if (this.isAdmin && entry.getValue().next().equals((Object)NetworkPermission.MEMBER)) {
                QOLGuiTextures.CHOOSE_NETWORK_ADD_PLAYER.render(graphics, 161, 4);
            }
            if (this.isAdmin && entry.getValue().previous().equals((Object)NetworkPermission.NONE)) {
                QOLGuiTextures.CHOOSE_NETWORK_DELETE_PLAYER.render(graphics, 174, 4);
            }
            if (this.isOwner && entry.getValue().next().equals((Object)NetworkPermission.ADMIN)) {
                QOLGuiTextures.CHOOSE_NETWORK_PROMOTE_PLAYER.render(graphics, 161, 4);
            }
            if (this.isOwner && entry.getValue().previous().equals((Object)NetworkPermission.MEMBER)) {
                QOLGuiTextures.CHOOSE_NETWORK_DEMOTE_PLAYER.render(graphics, 174, 4);
            }
        }
        matrixStack.popPose();
        return cardHeader;
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        float currentScroll = this.itemScroll.getValue(partialTicks);
        if (currentScroll < 1.0f && this.isAdmin && mouseX > this.lockX && mouseX <= this.lockX + 15 && mouseY > this.lockY && mouseY <= this.lockY + 15) {
            graphics.renderComponentTooltip(this.font, List.of(CreateLang.translate((String)(this.isLocked ? "gui.stock_keeper.network_locked" : "gui.stock_keeper.network_open"), (Object[])new Object[0]).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip_2", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
        if (currentScroll < 1.0f && this.isAdmin && mouseX > this.destroyX && mouseX <= this.destroyX + 15 && mouseY > this.destroyY && mouseY <= this.destroyY + 15) {
            graphics.renderComponentTooltip(this.font, List.of(CreateQOLLang.translate("gui.stock_manager.destruction_level", new Object[0]).add(this.destructionLevel.getName()).component(), CreateQOLLang.translate("gui.stock_manager.destruction_level_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateQOLLang.translate("gui.stock_manager.destruction_level_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip_2", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
        if (currentScroll < 1.0f && mouseX > this.switchX && mouseX <= this.switchX + 15 && mouseY > this.switchY && mouseY <= this.switchY + 15) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(List.of(CreateQOLLang.translate("gui.stock_manager.network_switch", new Object[0]).component(), CreateQOLLang.translate("gui.stock_manager.network_switch_tip", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()));
            if (this.links <= 1) {
                components.addAll(1, List.of(CreateQOLLang.translate("gui.choose_network.delete_warning", new Object[0]).style(ChatFormatting.RED).component(), CreateQOLLang.translate("gui.choose_network.delete_warning_1", new Object[0]).style(ChatFormatting.RED).component()));
            }
            graphics.renderComponentTooltip(this.font, components, mouseX, mouseY);
        }
        this.action(graphics, mouseX, mouseY, -1);
    }

    public boolean action(@Nullable GuiGraphics graphics, double mouseX, double mouseY, int click) {
        int fieldSize;
        int cardHeight;
        Object entry;
        int i;
        List<LogisticallyLinkedBehaviour> entries;
        if (mouseX < (double)this.leftPos || mouseX >= (double)(this.leftPos + this.imageWidth) || mouseY < (double)(this.topPos + 15) || mouseY >= (double)(this.topPos + this.windowHeight)) {
            return false;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int x = mx - this.leftPos - 20;
        int y = my - this.topPos - HEADER.getHeight();
        if (x < 0 || x >= 196) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y < (this.windowHeight - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / LOWER_BODY.getHeight() * UPPER_BODY.getHeight() - 20) {
            y = (int)((float)y + this.blocksScroll.getValue(0.0f));
            entries = this.behaviours;
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                cardHeight = 20;
                if (y >= cardHeight) {
                    if ((y -= cardHeight) >= 0) continue;
                    return false;
                }
                fieldSize = 165;
                if (x > 0 && x <= 30 && y > 0 && y <= 16 && Minecraft.getInstance().hitResult != null && Minecraft.getInstance().player != null) {
                    ItemStack stack = Minecraft.getInstance().level.getBlockState(entry.getPos()).getCloneItemStack(Minecraft.getInstance().hitResult, (LevelReader)Minecraft.getInstance().level, entry.getPos(), (Player)Minecraft.getInstance().player);
                    if (graphics != null) {
                        graphics.renderTooltip(this.font, stack, (int)mouseX, (int)mouseY);
                    }
                    return true;
                }
                if (x > fieldSize && x <= fieldSize + 16 && y > 0 && y <= 16) {
                    if (this.mayDestroy) {
                        if (Minecraft.getInstance().player.blockPosition().closerThan((Vec3i)entry.getPos(), (double)((Integer)CreateQOLConfigs.server().logistics.stockManagerMaxDestroyDistance.get()).intValue())) {
                            this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.break_block", new Object[0]).component()), mx, my);
                            if (click == 0) {
                                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new DestroyLogisticsNetworkComponentPacket(((StockManagerBlockEntity)((Object)((StockManagerMenu)this.menu).contentHolder)).getBlockPos(), entry.getPos()));
                                this.behaviours.remove(entry);
                            }
                            return true;
                        }
                        this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.too_far", new Object[0]).style(ChatFormatting.RED).component(), (Object)CreateQOLLang.translate("gui.stock_manager.too_far_1", new Object[0]).style(ChatFormatting.RED).component()), mx, my);
                    } else {
                        this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.destroy_no_permission", new Object[0]).style(ChatFormatting.RED).component(), (Object)CreateQOLLang.translate("gui.stock_manager.destroy_no_permission_1", new Object[0]).style(ChatFormatting.RED).component()), mx, my);
                    }
                }
                if ((x -= 18) >= 0 && (y -= 28) >= 0 && x <= 160) continue;
                return false;
            }
        }
        x = mx - this.leftPos - 20;
        y = my - this.topPos - this.lowerBodyStartY;
        if (x < 0 || x >= 196) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        y = (int)((float)y + this.playersScroll.getValue(0.0f));
        entries = new ArrayList<Map.Entry<UUID, NetworkPermission>>(this.permissions.entrySet());
        for (i = 0; i < entries.size(); ++i) {
            entry = (Map.Entry)entries.get(i);
            cardHeight = 20;
            if (y >= cardHeight) {
                if ((y -= cardHeight) >= 0) continue;
                return false;
            }
            fieldSize = 165;
            if (x <= 0 || x > 30 || y <= 0 || y <= 16) {
                // empty if block
            }
            if (x > fieldSize - 9 && x <= fieldSize + 4 && y > 0 && y <= 16) {
                NetworkPermission next = ((NetworkPermission)((Object)entry.getValue())).next();
                if (next == NetworkPermission.MEMBER && this.isAdmin) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.add_user", new Object[0]).component()), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), next);
                        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.getBlockPos(), (UUID)entry.getKey(), next));
                    }
                    return true;
                }
                if (next == NetworkPermission.ADMIN && this.isOwner) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.promote_to", new Object[0]).component().append((Component)CreateQOLLang.translateDirect("gui.stock_manager.permission." + next.getSerializedName(), new Object[0]))), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), next);
                        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.getBlockPos(), (UUID)entry.getKey(), next));
                    }
                    return true;
                }
            }
            if (x > fieldSize + 4 && x <= fieldSize + 16 && y > 0 && y <= 16) {
                NetworkPermission previous = ((NetworkPermission)((Object)entry.getValue())).previous();
                if (previous == NetworkPermission.NONE && this.isAdmin) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.remove_user", new Object[0]).component()), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), previous);
                        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.getBlockPos(), (UUID)entry.getKey(), previous));
                    }
                    return true;
                }
                if (previous == NetworkPermission.MEMBER && this.isOwner) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.demote_to", new Object[0]).component().append((Component)CreateQOLLang.translateDirect("gui.stock_manager.permission." + previous.getSerializedName(), new Object[0]))), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), previous);
                        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.getBlockPos(), (UUID)entry.getKey(), previous));
                    }
                    return true;
                }
            }
            if ((x -= 18) >= 0 && (y -= 28) >= 0 && x <= 160) continue;
            return false;
        }
        return false;
    }

    private void renderActionTooltip(@Nullable GuiGraphics graphics, List<Component> tooltip, int mx, int my) {
        if (graphics != null) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mx, my);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        boolean lmb = pButton == 0;
        boolean rmb = pButton == 1;
        int barX = 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.getGuiTop() + 15) && pMouseY < (double)(this.getGuiTop() + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212994);
            }
            return true;
        }
        if (this.isAdmin && this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.lockX && pMouseX <= (double)(this.lockX + 15) && pMouseY > (double)this.lockY && pMouseY <= (double)(this.lockY + 15)) {
            this.isLocked = !this.isLocked;
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new StockManagerLockPacket(this.blockEntity.getBlockPos(), this.isLocked));
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        if (this.isAdmin && this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.destroyX && pMouseX <= (double)(this.destroyX + 15) && pMouseY > (double)this.destroyY && pMouseY <= (double)(this.destroyY + 15)) {
            this.destructionLevel = this.destructionLevel.next();
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new StockManagerDestructionLevelPacket(this.blockEntity.getBlockPos(), this.destructionLevel));
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        if (this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.switchX && pMouseX <= (double)(this.switchX + 15) && pMouseY > (double)this.switchY && pMouseY <= (double)(this.switchY + 15)) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new OpenSwitchLogisticNetworkScreenPacket(this.blockEntity.getBlockPos()));
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        if (this.isOwner && !this.nameBox.isFocused() && pMouseY > (double)this.getGuiTop() && pMouseY < (double)(this.getGuiTop() + 14) && pMouseX > (double)this.getGuiLeft() && pMouseX < (double)(this.getGuiLeft() + HEADER.getWidth())) {
            this.nameBox.setFocused(true);
            this.nameBox.setHighlightPos(0);
            this.setFocused((GuiEventListener)this.nameBox);
            return true;
        }
        if (this.action(null, pMouseX, pMouseY, pButton)) {
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        return true;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212993);
            }
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseY < (double)this.lowerBodyStartY) {
            float chaseTarget = this.blocksScroll.getChaseTarget();
            float max = 40 - (3 + AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight() * 4);
            if ((max += (float)(this.behaviours.size() * 20 + 24)) > 0.0f) {
                chaseTarget -= (float)(scrollY * 12.0);
                chaseTarget = Mth.clamp((float)chaseTarget, (float)0.0f, (float)max);
                this.blocksScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
            } else {
                this.blocksScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
        } else {
            float chaseTarget = this.playersScroll.getChaseTarget();
            float max = 40 - (3 + AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight() * 4);
            if ((max += (float)(this.permissions.size() * 20 + 24)) > 0.0f) {
                chaseTarget -= (float)(scrollY * 12.0);
                chaseTarget = Mth.clamp((float)chaseTarget, (float)0.0f, (float)max);
                this.playersScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
            } else {
                this.playersScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
        }
        return true;
    }

    private void clampScrollBar() {
        float newTarget;
        int maxScroll = this.getMaxScroll();
        float prevTarget = this.itemScroll.getChaseTarget();
        if (prevTarget != (newTarget = Mth.clamp((float)prevTarget, (float)0.0f, (float)maxScroll))) {
            this.itemScroll.startWithValue((double)newTarget);
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        int maxScroll = Math.max(0, totalRows - visibleHeight + 50);
        return maxScroll;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0 || !this.scrollHandleActive) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        Window window = this.minecraft.getWindow();
        double scaleX = (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double scaleY = (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.getGuiTop() + 15 + barSize / 2;
        int maxY = this.getGuiTop() + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = 0;
        double target = (pMouseY - (double)this.getGuiTop() - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2);
        this.itemScroll.chase(Mth.clamp((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.minecraft.isWindowActive()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = Mth.clamp((double)pMouseY, (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.getWindow(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.getFocused() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.isFocused()) {
            this.nameBox.setFocused(false);
            if (!this.nameBox.getValue().equals(this.networkName)) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ModifyLogisticsNetworkPacket(this.blockEntity.getBlockPos(), this.nameBox.getValue()));
                this.networkName = this.nameBox.getValue();
                return true;
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void removed() {
        BlockPos pos = this.blockEntity.getBlockPos();
        super.removed();
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    private record PlayerEntry(UUID player, Component name, NetworkPermission permission) {
    }
}

