/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ItemButton
extends AbstractSimiWidget {
    protected ItemStack icon;
    public boolean green;
    private final OnClick clicked;

    public ItemButton(int x, int y, ItemStack icon, OnClick onClick) {
        this(x, y, 18, 18, icon, onClick);
    }

    public ItemButton(int x, int y, int w, int h, ItemStack icon, OnClick onClick) {
        super(x, y, w, h);
        this.icon = icon;
        this.clicked = onClick;
    }

    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            boolean bl = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            AllGuiTextures button = !this.active ? AllGuiTextures.BUTTON_DISABLED : (this.isHovered && AllKeys.isMouseButtonDown((int)0) ? AllGuiTextures.BUTTON_DOWN : (this.isHovered ? AllGuiTextures.BUTTON_HOVER : (this.green ? AllGuiTextures.BUTTON_GREEN : AllGuiTextures.BUTTON)));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawBg(graphics, button);
            GuiGameElement.of((ItemStack)this.icon).render(graphics, this.getX() + 1, this.getY() + 1);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.visible && this.active && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width) && mouseY < (double)(this.getY() + this.height) && button == 0) {
            this.clicked.onClick(this);
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    protected void drawBg(GuiGraphics graphics, AllGuiTextures button) {
        graphics.blit(button.location, this.getX(), this.getY(), button.getStartX(), button.getStartY(), button.getWidth(), button.getHeight());
    }

    public void setToolTip(Component text) {
        this.toolTip.clear();
        this.toolTip.add(text);
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public static interface OnClick {
        public void onClick(ItemButton var1);
    }
}

