/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class ScrollableEditBox
extends EditBox {
    private final List<Component> toolTips = new ArrayList<Component>();
    private MutableComponent prefix = Component.empty();

    public ScrollableEditBox(Font font, int x, int y, Component text) {
        super(font, x, y, text);
    }

    public ScrollableEditBox(Font font, int x, int y, int width, int height, Component text) {
        super(font, x, y, width, height, text);
    }

    public ScrollableEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox copiable, Component text) {
        super(font, x, y, width, height, copiable, text);
    }

    public ScrollableEditBox setPrefix(Component prefix) {
        this.prefix = prefix.copy();
        return this;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int state = this.getCastedValue();
        int priorState = this.getCastedValue();
        boolean shifted = AllKeys.shiftDown();
        int step = (int)Math.signum(deltaY);
        if (AllKeys.ctrlDown()) {
            step *= 90;
        } else if (shifted) {
            step *= 45;
        }
        if ((state += step) < -180 || state >= 180) {
            state = priorState;
        }
        if (priorState != state) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (float)(state + 180) / 360.0f)));
            this.setValue("" + state);
        }
        return priorState != state;
    }

    public void setValue(String p_94145_) {
        super.setValue(p_94145_);
        this.updateTooltip();
    }

    public int getCastedValue() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float p_283101_) {
        super.renderWidget(graphics, mouseX, mouseY, p_283101_);
        if (this.isHovered) {
            List<Component> tooltip = this.toolTips;
            if (tooltip.isEmpty()) {
                return;
            }
            graphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, mouseX, mouseY);
        }
    }

    protected void updateTooltip() {
        this.toolTips.clear();
        MutableComponent title = this.prefix.append((Component)Component.literal((String)(this.getValue() + "\u00b0")));
        MutableComponent scrollToModify = CreateLang.translateDirect((String)"gui.scrollInput.scrollToModify", (Object[])new Object[0]);
        this.toolTips.add((Component)title.plainCopy().withStyle(s -> s.withColor(AbstractSimiWidget.HEADER_RGB.getRGB())));
        this.toolTips.add((Component)scrollToModify.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
    }
}

