/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.gui.AllIcons;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.tabs.PublishedAnimationsTab;
import fr.iglee42.createqualityoflife.packets.DeleteAnimationPacket;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.registries.QOLIcons;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.animation.PublishedAnimationsManager;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class StatueAnimationWidget
extends AbstractSimiWidget {
    private final PublishedAnimationsManager.PublishedAnimation animation;
    private final PublishedAnimationsTab parent;
    private final Statue statue;

    public StatueAnimationWidget(int x, int y, PublishedAnimationsManager.PublishedAnimation animation, PublishedAnimationsTab parent) {
        super(x, y, 45, 60);
        this.animation = animation;
        this.parent = parent;
        this.statue = new Statue((EntityType<? extends LivingEntity>)((EntityType)QOLEntityTypes.STATUE.get()), (Level)Minecraft.getInstance().level);
        CompoundTag tag = new CompoundTag();
        parent.getExampleStatue().saveWithoutId(tag);
        this.statue.load(tag);
        this.statue.setCustomNameVisible(false);
        StatueAnimation anim = animation.animation();
        anim.setLoop(true);
        this.statue.setAnimation(anim);
        this.statue.setAnimationProgress(0);
        this.statue.setAnimationPlaying(true);
    }

    public void tick() {
        super.tick();
        this.statue.tickAnimation();
    }

    protected void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        this.drawScrollingString(graphics, Minecraft.getInstance().font, (Component)Component.literal((String)this.animation.name()), this.getX(), this.getX() + this.getWidth(), this.getY() - 9, 0xFFFFFF);
        graphics.pose().pushPose();
        graphics.pose().scale(0.8f, 0.8f, 0.8f);
        String player = Minecraft.getInstance().level.getPlayerByUUID(this.animation.publisher()) != null ? Minecraft.getInstance().level.getPlayerByUUID(this.animation.publisher()).getName().getString() : "Unknown";
        graphics.drawScrollingString(Minecraft.getInstance().font, (Component)Component.literal((String)player), (int)((double)(this.getX() + 2) * 1.25), (int)((double)(this.getX() + this.getWidth() - 12) * 1.25), (int)((double)(this.getY() + this.getHeight() + 3) * 1.25), 5726074);
        graphics.pose().popPose();
        QOLGuiTextures button = !this.active ? QOLGuiTextures.POSE_BUTTON_DISABLED : (this.isHovered && AllKeys.isMouseButtonDown((int)0) ? QOLGuiTextures.POSE_BUTTON_CLICKED : (this.isHovered ? QOLGuiTextures.POSE_BUTTON_HOVER : QOLGuiTextures.POSE_BUTTON));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        button.render(graphics, this.getX(), this.getY());
        float renderTime = AnimationTickHolder.getRenderTime();
        int posX = this.getX() + 10;
        int posY = this.getY() + 7;
        InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)posX, (float)posY, (float)24.0f, (Vector3f)new Vector3f(this.statue.getBbWidth(), this.statue.getBbHeight(), 0.0f), (Quaternionf)new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), (float)Math.toRadians(renderTime / 96.0f * 360.0f), 0.0f), null, (LivingEntity)this.statue);
        if (Minecraft.getInstance().player.getUUID().equals(this.animation.publisher()) || Minecraft.getInstance().player.hasPermissions(1)) {
            boolean hovered = mouseX >= this.getX() + this.width - 14 && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() + this.getHeight() - 1 && mouseY <= this.getY() + this.getHeight() + 11;
            graphics.pose().pushPose();
            graphics.pose().translate((float)(this.getX() + this.getWidth() - 11), (float)(this.getY() + this.getHeight() - 1), 100.0f);
            graphics.pose().scale(11.0f, 11.0f, 11.0f);
            if (hovered) {
                QOLIcons.I_DISCARD_HOVER.render(graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xFFFFFF);
            }
            AllIcons.I_CONFIG_DISCARD.render(graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xFF0000);
            graphics.pose().popPose();
            if (hovered) {
                graphics.renderComponentTooltip(Minecraft.getInstance().font, List.of(CreateQOLLang.translateDirect("statue.animation.delete", new Object[0])), mouseX, mouseY);
            }
        }
    }

    private void drawScrollingString(GuiGraphics graphics, Font font, Component text, int minX, int maxX, int y, int color) {
        int maxWidth = maxX - minX;
        int textWidth = font.width(text.getVisualOrderText());
        if (textWidth <= maxWidth) {
            graphics.drawCenteredString(font, text, (minX + maxX) / 2, y, color);
        } else {
            Objects.requireNonNull(font);
            AbstractWidget.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)text, (int)minX, (int)(y - 1), (int)maxX, (int)(y + 8), (int)color);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean hovered;
        boolean bl = hovered = mouseX >= (double)(this.getX() + this.width - 14) && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)(this.getY() + this.getHeight() - 1) && mouseY <= (double)(this.getY() + this.getHeight() + 11);
        if (button == 0 && hovered) {
            if (this.animation.publisher().equals(Minecraft.getInstance().player.getUUID()) || Minecraft.getInstance().player.hasPermissions(1)) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new DeleteAnimationPacket(this.animation.id()));
                this.parent.getAnimations().remove((Object)this);
                this.parent.getParent().removeWidget((GuiEventListener)this);
                this.parent.updateAnimationsPos(this.parent.getParent().getGuiLeft() + 20 + 67 + (this.parent.getParent().isHideBackground() ? 110 : 0), this.parent.getParent().getGuiTop() + 30);
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
        } else if (this.isHovered() && button == 0) {
            this.parent.getExampleStatue().setAnimation(this.animation.animation());
            this.parent.getParent().sendUpdatePacket();
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }
}

