/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueDefaultRotations;
import java.util.Objects;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class StatuePoseWidget
extends AbstractSimiWidget {
    private final StatueDefaultRotations pose;
    private final ConfigureStatueScreen parent;

    public StatuePoseWidget(int x, int y, StatueDefaultRotations pose, ConfigureStatueScreen parent) {
        super(x, y, 45, 60);
        this.pose = pose;
        this.parent = parent;
        this.withCallback(() -> {
            pose.applyToStatue(parent.getExampleStatue());
            parent.sendUpdatePacket();
        });
    }

    protected void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        this.drawScrollingString(graphics, Minecraft.getInstance().font, (Component)this.pose.getName(), this.getX(), this.getX() + this.getWidth(), this.getY() - 11, 0xFFFFFF);
        graphics.pose().pushPose();
        graphics.pose().scale(0.5f, 0.5f, 0.5f);
        if (mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY > this.getY() + this.getHeight() && mouseY <= this.getY() + this.getHeight() + 11 && this.pose.getSource().getString().equals("Vanilla Tweaks")) {
            this.drawScrollingString(graphics, Minecraft.getInstance().font, (Component)this.pose.getSource().withStyle(ChatFormatting.UNDERLINE), this.getX() * 2, (this.getX() + this.getWidth()) * 2, (this.getY() + this.getHeight() + 2) * 2, 5726074);
        } else {
            this.drawScrollingString(graphics, Minecraft.getInstance().font, (Component)this.pose.getSource(), this.getX() * 2, (this.getX() + this.getWidth()) * 2, (this.getY() + this.getHeight() + 2) * 2, 5726074);
        }
        graphics.pose().popPose();
        QOLGuiTextures button = !this.active ? QOLGuiTextures.POSE_BUTTON_DISABLED : (this.isHovered && AllKeys.isMouseButtonDown((int)0) ? QOLGuiTextures.POSE_BUTTON_CLICKED : (this.isHovered ? QOLGuiTextures.POSE_BUTTON_HOVER : QOLGuiTextures.POSE_BUTTON));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        button.render(graphics, this.getX(), this.getY());
        float renderTime = AnimationTickHolder.getRenderTime();
        Statue example = new Statue((EntityType<? extends LivingEntity>)((EntityType)QOLEntityTypes.STATUE.get()), (Level)Minecraft.getInstance().level);
        CompoundTag tag = new CompoundTag();
        this.parent.getExampleStatue().saveWithoutId(tag);
        example.load(tag);
        example.setCustomNameVisible(false);
        this.pose.applyToStatue(example);
        int posX = this.getX() + 10;
        int posY = this.getY() + 7;
        InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)posX, (float)posY, (float)24.0f, (Vector3f)new Vector3f(example.getBbWidth(), example.getBbHeight(), 0.0f), (Quaternionf)new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), (float)Math.toRadians(renderTime / 96.0f * 360.0f), 0.0f), null, (LivingEntity)example);
    }

    private void drawScrollingString(GuiGraphics graphics, Font font, Component text, int minX, int maxX, int y, int color) {
        int maxWidth = maxX - minX;
        int textWidth = font.width(text.getVisualOrderText());
        if (textWidth <= maxWidth) {
            graphics.drawCenteredString(font, text, (minX + maxX) / 2, y, color);
        } else {
            Objects.requireNonNull(font);
            AbstractWidget.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)text, (int)minX, (int)(y - 1), (int)maxX, (int)(y + 8), (int)color);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY > (double)(this.getY() + this.getHeight()) && mouseY <= (double)(this.getY() + this.getHeight() + 11) && this.pose.getSource().getString().equals("Vanilla Tweaks")) {
            ConfirmLinkScreen.confirmLinkNow((Screen)this.parent, (String)"https://vanillatweaks.net/");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

