/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.mixin.accessor.CropBlockAccessor;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceHoe
extends HoeItem
implements QOLConfigurableItem {
    public RefinedRadianceHoe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.harvesting").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.HARVESTING, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Harvesting", (Boolean)stack.getOrDefault(QOLDataComponents.HARVESTING, (Object)false), QOLDataComponents.HARVESTING, List.of("Should replant destroyed crops"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        RefinedRadianceHoe.toggleAbility(player.getItemInHand(hand), player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.harvesting", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.HARVESTING, (Object)false) == false;
        stack.set(QOLDataComponents.HARVESTING, (Object)enable);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.harvesting", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, enable, false, true)).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().is((Item)QOLItems.REFINED_RADIANCE_HOE.get()) && !event.getPlayer().getMainHandItem().is((Item)QOLItems.SHADOW_RADIANCE_HOE.get())) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)event.getPlayer().getMainHandItem().getOrDefault(QOLDataComponents.HARVESTING, (Object)false)).booleanValue()) {
            return;
        }
        if (RefinedRadianceHoe.tryHarvestCrop(event.getPlayer().level(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    public static boolean tryHarvestCrop(Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        BlockState stateVisited = world.getBlockState(pos);
        if (stateVisited.isAir() || AllTags.AllBlockTags.NON_HARVESTABLE.matches(stateVisited)) {
            return false;
        }
        boolean notCropButCuttable = false;
        if (!RefinedRadianceHoe.isValidCrop(world, pos, stateVisited)) {
            if (RefinedRadianceHoe.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return false;
            }
        }
        ItemStack item = ItemStack.EMPTY;
        float effectChance = 1.0f;
        if (stateVisited.is(BlockTags.LEAVES)) {
            item = new ItemStack((ItemLike)Items.SHEARS);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockState state = stateVisited;
        BlockHelper.destroyBlockAs((Level)world, (BlockPos)pos, null, (ItemStack)item, (float)effectChance, stack -> {
            if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && ItemHelper.sameItem((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)state.getBlock()))) {
                stack.shrink(1);
                seedSubtracted.setTrue();
            }
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
        });
        BlockState cutCrop = RefinedRadianceHoe.cutCrop(world, pos, stateVisited);
        world.setBlockAndUpdate(pos, cutCrop.canSurvive((LevelReader)world, pos) ? cutCrop : Blocks.AIR.defaultBlockState());
        return true;
    }

    public static boolean isValidCrop(Level world, BlockPos pos, BlockState state) {
        boolean harvestPartial = (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (harvestPartial) {
                return state != crop.getStateForAge(0) || !replant;
            }
            return crop.isMaxAge(state);
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty() || state.getBlock() instanceof CocoaBlock) {
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty)) continue;
                IntegerProperty ageProperty = (IntegerProperty)property;
                if (!property.getName().equals(BlockStateProperties.AGE_1.getName())) continue;
                int age = (Integer)state.getValue((Property)ageProperty);
                if (state.getBlock() instanceof SweetBerryBushBlock && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.getPossibleValues().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidOther(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() instanceof CropBlock) {
            return false;
        }
        if (state.getBlock() instanceof SugarCaneBlock) {
            return true;
        }
        if (state.is(BlockTags.LEAVES)) {
            return true;
        }
        if (state.getBlock() instanceof CocoaBlock) {
            return (Integer)state.getValue((Property)CocoaBlock.AGE) == 2;
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            if (state.getBlock() instanceof GrowingPlantBlock) {
                return true;
            }
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty) || !property.getName().equals(BlockStateProperties.AGE_1.getName())) continue;
                return false;
            }
            if (state.getBlock() instanceof SpecialPlantable) {
                return true;
            }
        }
        return false;
    }

    private static BlockState cutCrop(Level world, BlockPos pos, BlockState state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.getFluidState().isEmpty()) {
                return Blocks.AIR.defaultBlockState();
            }
            return state.getFluidState().createLegacyBlock();
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            BlockState newState = crop.getStateForAge(0);
            if (!newState.is(block)) {
                return newState;
            }
            IntegerProperty ageProperty = ((CropBlockAccessor)crop).create$callGetAgeProperty();
            return (BlockState)state.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0));
        }
        if (block == Blocks.SWEET_BERRY_BUSH) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1));
        }
        if (AllTags.AllBlockTags.SUGAR_CANE_VARIANTS.matches(block) || block instanceof GrowingPlantBlock) {
            if (state.getFluidState().isEmpty()) {
                return Blocks.AIR.defaultBlockState();
            }
            return state.getFluidState().createLegacyBlock();
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty() || block instanceof CocoaBlock) {
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty) || !property.getName().equals(BlockStateProperties.AGE_1.getName())) continue;
                return (BlockState)state.setValue((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.getFluidState().isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return state.getFluidState().createLegacyBlock();
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

