/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowsteel;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelAxe
extends AxeItem
implements QOLConfigurableItem {
    public ShadowSteelAxe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_STEEL, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.tree_decapitation").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.treeDecapitation.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.TREE_DECAPITATION, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Tree Decapitation", (Boolean)stack.getOrDefault(QOLDataComponents.TREE_DECAPITATION, (Object)false), QOLDataComponents.TREE_DECAPITATION, List.of("Should destroy a tree when a log is broken like a mechanical saw"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.treeDecapitation.get()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        ShadowSteelAxe.toggleAbility(player.getItemInHand(hand), player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.treeDecapitation.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.tree_decapitation", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.TREE_DECAPITATION, (Object)false) == false;
        stack.set(QOLDataComponents.TREE_DECAPITATION, (Object)enable);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.tree_decapitation", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, enable, false, true)).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().is((Item)QOLItems.SHADOW_STEEL_AXE.get()) && !event.getPlayer().getMainHandItem().is((Item)QOLItems.SHADOW_RADIANCE_AXE.get())) {
            return;
        }
        if (!((Boolean)event.getPlayer().getMainHandItem().getOrDefault(QOLDataComponents.TREE_DECAPITATION, (Object)false)).booleanValue()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().isCorrectToolForDrops(event.getState())) {
            return;
        }
        if (!SawBlockEntity.isSawable((BlockState)event.getState())) {
            return;
        }
        BlockState stateToBreak = event.getState();
        BlockPos breakingPos = event.getPos();
        Level level = event.getPlayer().level();
        Optional dynamicTree = TreeCutter.findDynamicTree((Block)stateToBreak.getBlock(), (BlockPos)breakingPos);
        if (dynamicTree.isPresent()) {
            ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(level, null, (pos, stack) -> ShadowSteelAxe.dropItemFromCutTree(level, pos, stack));
            return;
        }
        Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)breakingPos), (RandomSource)level.random, (float)0.125f);
        BlockHelper.destroyBlock((Level)level, (BlockPos)breakingPos, (float)1.0f, stack -> {
            if (stack.isEmpty()) {
                return;
            }
            if (!level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                return;
            }
            if (level.restoringBlockSnapshots) {
                return;
            }
            ItemEntity itementity = new ItemEntity(level, vec.x, vec.y, vec.z, stack);
            itementity.setDefaultPickUpDelay();
            itementity.setDeltaMovement(Vec3.ZERO);
            level.addFreshEntity((Entity)itementity);
        });
        TreeCutter.findTree((BlockGetter)level, (BlockPos)breakingPos, (BlockState)stateToBreak).destroyBlocks(level, null, (pos, stack) -> ShadowSteelAxe.dropItemFromCutTree(level, pos, stack));
    }

    private static void dropItemFromCutTree(Level level, BlockPos pos, ItemStack stack) {
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(level, dropPos.x, dropPos.y, dropPos.z, stack);
        entity.setDeltaMovement(Vec3.ZERO);
        level.addFreshEntity((Entity)entity);
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BOTH;
    }
}

