/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins;

import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.screens.DisplayBoardEditScreen;
import fr.iglee42.createqualityoflife.utils.Features;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlapDisplayBlock.class})
public class FlapDisplayBlockMixin {
    @Inject(method={"useItemOn"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void inject(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<ItemInteractionResult> cir) {
        BlockEntity blockEntity;
        if (player.isCrouching() && stack.isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof FlapDisplayBlockEntity) {
            FlapDisplayBlockEntity be = (FlapDisplayBlockEntity)blockEntity;
            if (CreateQOL.isActivate(Features.DISPLAY_BOARD_MODIFICATION)) {
                if (!be.isController) {
                    be = be.getController();
                }
                FlapDisplayBlockEntity finalBe = be;
                double yCoord = hitResult.getLocation().add((Vec3)Vec3.atLowerCornerOf((Vec3i)hitResult.getDirection().getOpposite().getNormal()).scale((double)0.125)).y;
                int lineIndex = finalBe.getLineIndexAt(yCoord);
                RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FlapDisplayBlockMixin.createQualityOfLife$displayScreen(finalBe, player, lineIndex));
                cir.setReturnValue((Object)ItemInteractionResult.SUCCESS);
            }
        }
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private static void createQualityOfLife$displayScreen(FlapDisplayBlockEntity be, Player player, int lineIndex) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        ScreenOpener.open((Screen)new DisplayBoardEditScreen(be, lineIndex));
    }
}

