/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import fr.iglee42.createqualityoflife.utils.ShadowRadianceEffects;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ChangeItemComponentPacket
implements ServerboundPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeItemComponentPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.slot, (StreamCodec)ByteBufCodecs.INT, p -> p.value, (StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.componentId, ChangeItemComponentPacket::new);
    private int slot;
    private int value;
    private String componentId;

    public ChangeItemComponentPacket(int slot, int value, String componentId) {
        this.slot = slot;
        this.value = value;
        this.componentId = componentId;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QOLPackets.CHANGE_ARMOR_COMPONENT;
    }

    public void handle(ServerPlayer player) {
        DataComponentType component = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)this.componentId));
        if (component == null) {
            return;
        }
        if (component.equals(QOLDataComponents.ARMOR_RENDER_TYPE)) {
            player.getInventory().getItem(this.slot).set(QOLDataComponents.ARMOR_RENDER_TYPE, (Object)ArmorRenderType.BY_ID.apply(this.value));
        } else if (component.equals(QOLDataComponents.PREFERRED_RENDER)) {
            player.getInventory().getItem(this.slot).set(QOLDataComponents.PREFERRED_RENDER, (Object)PreferredRender.BY_ID.apply(this.value));
        } else if (component.equals(QOLDataComponents.EFFECT)) {
            player.getInventory().getItem(this.slot).set(QOLDataComponents.EFFECT, (Object)ShadowRadianceEffects.BY_ID.apply(this.value));
        } else {
            DataComponentType bComponent = component;
            player.getInventory().getItem(this.slot).set(bComponent, (Object)(this.value != 0 ? 1 : 0));
        }
    }
}

