/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ToggleArmorEffectPacket(EquipmentSlot slot) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, ToggleArmorEffectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, p -> (byte)p.slot().ordinal(), ToggleArmorEffectPacket::new);

    public ToggleArmorEffectPacket(byte slot) {
        this(EquipmentSlot.values()[slot]);
    }

    public void handle(ServerPlayer player) {
        if (player != null) {
            ItemStack stack = player.getItemBySlot(this.slot);
            if (stack.isEmpty()) {
                return;
            }
            Item item = stack.getItem();
            if (!(item instanceof QOLConfigurableItem)) {
                return;
            }
            QOLConfigurableItem it = (QOLConfigurableItem)item;
            if (it.providedEffect(stack) == null) {
                return;
            }
            boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.ARMOR_EFFECT, (Object)true) == false;
            stack.set(QOLDataComponents.ARMOR_EFFECT, (Object)enable);
            player.displayClientMessage((Component)Component.translatable((String)stack.getDescriptionId()).append((Component)Component.literal((String)" Effect : ").append(QOLConfigurableItem.chooseState(true, true, enable, false, true))).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QOLPackets.TOGGLE_ARMOR_EFFECT;
    }
}

