/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.registries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.gui.AllIcons;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class QOLIcons
extends AllIcons {
    public static final ResourceLocation ICON_ATLAS = ResourceLocation.fromNamespaceAndPath((String)"createqol", (String)"textures/gui/icons.png");
    public static final int ICON_ATLAS_SIZE = 256;
    private static int x = 0;
    private static int y = -1;
    private final int iconX;
    private final int iconY;
    public static final QOLIcons I_INVENTORY = QOLIcons.newRow();
    public static final QOLIcons I_ARMOR = QOLIcons.next();
    public static final QOLIcons I_OFF_HAND = QOLIcons.next();
    public static final QOLIcons I_UNLOCKED_STATUE = QOLIcons.newRow();
    public static final QOLIcons I_LOCKED_STATUE = QOLIcons.next();
    public static final QOLIcons I_HAT = QOLIcons.next();
    public static final QOLIcons I_JACKET = QOLIcons.next();
    public static final QOLIcons I_LEFT_SLEEVE = QOLIcons.next();
    public static final QOLIcons I_RIGHT_SLEEVE = QOLIcons.next();
    public static final QOLIcons I_LEFT_PANTS = QOLIcons.next();
    public static final QOLIcons I_RIGHT_PANTS = QOLIcons.next();
    public static final QOLIcons I_CAPE_OFF = QOLIcons.next();
    public static final QOLIcons I_CAPE_ON = QOLIcons.next();
    public static final QOLIcons I_STATUE = QOLIcons.next();
    public static final QOLIcons I_DISCARD_HOVER = QOLIcons.next();

    public QOLIcons(int x, int y) {
        super(x, y);
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    private static QOLIcons next() {
        return new QOLIcons(++x, y);
    }

    private static QOLIcons newRow() {
        x = 0;
        return new QOLIcons(0, ++y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_ATLAS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(ICON_ATLAS, x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 256, 256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.getBuffer(RenderType.text((ResourceLocation)ICON_ATLAS));
        Matrix4f matrix = ms.last().pose();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX * 1.0f / 256.0f;
        float u2 = (float)(this.iconX + 16) * 1.0f / 256.0f;
        float v1 = (float)this.iconY * 1.0f / 256.0f;
        float v2 = (float)(this.iconY + 16) * 1.0f / 256.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.addVertex(matrix, (float)vec.x, (float)vec.y, (float)vec.z).setColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).setUv(u, v).setLight(light);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DelegatedStencilElement asStencil() {
        return (DelegatedStencilElement)new DelegatedStencilElement().withStencilRenderer((ms, w, h, alpha) -> this.render(ms, 0, 0)).withBounds(16, 16);
    }
}

