/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.iglee42.createqualityoflife.statue.Statue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StatueModel
extends PlayerModel<Statue> {
    public final ModelPart slimLeftArm;
    public final ModelPart slimRightArm;
    public final ModelPart slimLeftSleeve;
    public final ModelPart slimRightSleeve;
    private final ModelPart cloak;
    private boolean slim;

    public StatueModel(ModelPart modelPart, boolean slim) {
        super(modelPart, slim);
        this.slimLeftArm = modelPart.getChild("slim_left_arm");
        this.slimRightArm = modelPart.getChild("slim_right_arm");
        this.slimLeftSleeve = modelPart.getChild("slim_left_sleeve");
        this.slimRightSleeve = modelPart.getChild("slim_right_sleeve");
        this.cloak = modelPart.getChild("cloak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)false);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("slim_left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        partDefinition.addOrReplaceChild("slim_right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        partDefinition.addOrReplaceChild("slim_left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        partDefinition.addOrReplaceChild("slim_right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return Iterables.concat((Iterable)super.headParts(), (Iterable)ImmutableList.of((Object)this.hat));
    }

    protected Iterable<ModelPart> bodyParts() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.bodyParts().spliterator(), false).filter(modelPart -> modelPart != this.hat), Stream.of(this.slimLeftArm, this.slimRightArm, this.slimLeftSleeve, this.slimRightSleeve)).collect(ImmutableList.toImmutableList());
    }

    public void setupAnim(Statue entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        StatueModel.setupPoseAnim(this, entity);
        this.setupSlimAnim(entity);
        this.setupCloakAnim(entity);
        this.hat.copyFrom(this.head);
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.slimLeftSleeve.copyFrom(this.slimLeftArm);
        this.slimRightSleeve.copyFrom(this.slimRightArm);
        this.jacket.copyFrom(this.body);
        this.setupCrouchingAnimCape(entity);
    }

    private void setupSlimAnim(Statue entity) {
        this.slimLeftArm.visible = true;
        this.leftArm.visible = true;
        this.slimRightArm.visible = true;
        this.rightArm.visible = true;
        this.slim = entity.isSlimArms();
        this.slimLeftArm.xRot = (float)Math.PI / 180 * entity.getLeftArmPose().getX();
        this.slimLeftArm.yRot = (float)Math.PI / 180 * entity.getLeftArmPose().getY();
        this.slimLeftArm.zRot = (float)Math.PI / 180 * entity.getLeftArmPose().getZ();
        this.slimRightArm.xRot = (float)Math.PI / 180 * entity.getRightArmPose().getX();
        this.slimRightArm.yRot = (float)Math.PI / 180 * entity.getRightArmPose().getY();
        this.slimRightArm.zRot = (float)Math.PI / 180 * entity.getRightArmPose().getZ();
        if (this.slim) {
            this.leftSleeve.visible = false;
            this.leftArm.visible = false;
            this.rightSleeve.visible = false;
            this.rightArm.visible = false;
        } else {
            this.slimLeftSleeve.visible = false;
            this.slimLeftArm.visible = false;
            this.slimRightSleeve.visible = false;
            this.slimRightArm.visible = false;
        }
    }

    private void setupCloakAnim(Statue entity) {
        this.cloak.xRot = (float)(-Math.PI) / 180 * entity.getBodyPose().getX();
        this.cloak.yRot = (float)Math.PI / 180 * entity.getBodyPose().getY();
        this.cloak.zRot = (float)(-Math.PI) / 180 * entity.getBodyPose().getZ();
    }

    private void setupCrouchingAnimCape(Statue entity) {
        if (entity.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            if (this.crouching) {
                this.cloak.z = 1.4f;
                this.cloak.y = 1.85f;
            } else {
                this.cloak.z = 0.0f;
                this.cloak.y = 0.0f;
            }
        } else if (this.crouching) {
            this.cloak.z = 0.3f;
            this.cloak.y = 0.8f;
        } else {
            this.cloak.z = -1.1f;
            this.cloak.y = -0.85f;
        }
    }

    public void translateToHand(HumanoidArm side, PoseStack poseStack) {
        ModelPart modelPart = this.getArm(side);
        if (this.slim) {
            float f = 0.5f * (float)(side == HumanoidArm.RIGHT ? 1 : -1);
            modelPart.x += f;
            modelPart.translateAndRotate(poseStack);
            modelPart.x -= f;
        } else {
            modelPart.translateAndRotate(poseStack);
        }
    }

    public static <T extends Statue> void setupPoseAnim(HumanoidModel<T> model, T entity) {
        model.head.xRot = (float)Math.PI / 180 * entity.getHeadPose().getX();
        model.head.yRot = (float)Math.PI / 180 * entity.getHeadPose().getY();
        model.head.zRot = (float)Math.PI / 180 * entity.getHeadPose().getZ();
        model.leftArm.xRot = (float)Math.PI / 180 * entity.getLeftArmPose().getX();
        model.leftArm.yRot = (float)Math.PI / 180 * entity.getLeftArmPose().getY();
        model.leftArm.zRot = (float)Math.PI / 180 * entity.getLeftArmPose().getZ();
        model.rightArm.xRot = (float)Math.PI / 180 * entity.getRightArmPose().getX();
        model.rightArm.yRot = (float)Math.PI / 180 * entity.getRightArmPose().getY();
        model.rightArm.zRot = (float)Math.PI / 180 * entity.getRightArmPose().getZ();
        model.leftLeg.xRot = (float)Math.PI / 180 * entity.getLeftLegPose().getX();
        model.leftLeg.yRot = (float)Math.PI / 180 * entity.getLeftLegPose().getY();
        model.leftLeg.zRot = (float)Math.PI / 180 * entity.getLeftLegPose().getZ();
        model.rightLeg.xRot = (float)Math.PI / 180 * entity.getRightLegPose().getX();
        model.rightLeg.yRot = (float)Math.PI / 180 * entity.getRightLegPose().getY();
        model.rightLeg.zRot = (float)Math.PI / 180 * entity.getRightLegPose().getZ();
        StatueModel.setupCrouchingAnim(model);
    }

    private static <T extends Statue> void setupCrouchingAnim(HumanoidModel<T> model) {
        if (model.crouching) {
            model.body.xRot = 0.5f;
            model.rightArm.xRot += 0.4f;
            model.leftArm.xRot += 0.4f;
            model.rightLeg.z = 4.0f;
            model.leftLeg.z = 4.0f;
            model.rightLeg.y = 12.2f;
            model.leftLeg.y = 12.2f;
            model.head.y = 4.2f;
            model.body.y = 3.2f;
            model.leftArm.y = 5.2f;
            model.rightArm.y = 5.2f;
        } else {
            model.body.xRot = 0.0f;
            model.rightLeg.z = 0.1f;
            model.leftLeg.z = 0.1f;
            model.rightLeg.y = 12.0f;
            model.leftLeg.y = 12.0f;
            model.head.y = 0.0f;
            model.body.y = 0.0f;
            model.leftArm.y = 2.0f;
            model.rightArm.y = 2.0f;
        }
    }
}

