/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue.animation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimationFrame;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class StatueAnimation {
    public static final Codec<StatueAnimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatueAnimationFrame.CODEC.listOf().fieldOf("frames").forGetter(StatueAnimation::getFrames), (App)Codec.BOOL.fieldOf("loop").forGetter(StatueAnimation::isLooping), (App)Codec.BOOL.fieldOf("revert").forGetter(StatueAnimation::canBeRevert)).apply((Applicative)instance, (frames, loop, revert) -> new StatueAnimation(StatueAnimation.calculateDuration(frames), (boolean)loop, (boolean)revert, (List<StatueAnimationFrame>)frames)));
    public static final StreamCodec<FriendlyByteBuf, StatueAnimation> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, StatueAnimation>(){

        public StatueAnimation decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<StatueAnimationFrame> frames = new ArrayList<StatueAnimationFrame>(size);
            for (int i = 0; i < size; ++i) {
                frames.add((StatueAnimationFrame)StatueAnimationFrame.STREAM_CODEC.decode((Object)buf));
            }
            boolean loop = buf.readBoolean();
            boolean revert = buf.readBoolean();
            return new StatueAnimation(StatueAnimation.calculateDuration(frames), loop, revert, frames);
        }

        public void encode(FriendlyByteBuf buf, StatueAnimation animation) {
            buf.writeInt(animation.getFrames().size());
            animation.getFrames().forEach(f -> StatueAnimationFrame.STREAM_CODEC.encode((Object)buf, f));
            buf.writeBoolean(animation.isLooping());
            buf.writeBoolean(animation.canBeRevert());
        }
    };
    private int duration;
    private boolean loop;
    private boolean revert;
    private List<StatueAnimationFrame> frames;

    public StatueAnimation() {
        this.frames = new ArrayList<StatueAnimationFrame>();
    }

    public StatueAnimation(int duration, boolean loop, boolean revert, List<StatueAnimationFrame> frames) {
        this.duration = duration;
        this.loop = loop;
        this.frames = new ArrayList<StatueAnimationFrame>(frames);
        this.revert = revert;
    }

    public StatueAnimation addFrame(StatueAnimationFrame frame) {
        this.frames.add(frame);
        this.frames.sort(Comparator.comparingInt(StatueAnimationFrame::getTick));
        this.duration = StatueAnimation.calculateDuration(this.frames);
        return this;
    }

    public StatueAnimation loop() {
        this.loop = !this.loop;
        return this;
    }

    public StatueAnimation revert() {
        this.revert = !this.revert;
        return this;
    }

    public boolean canBeRevert() {
        return this.revert;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    private static int calculateDuration(List<StatueAnimationFrame> frames) {
        if (frames.isEmpty()) {
            return 0;
        }
        ArrayList<StatueAnimationFrame> sortedFrames = new ArrayList<StatueAnimationFrame>(frames);
        sortedFrames.sort(Comparator.comparingInt(StatueAnimationFrame::getTick));
        return ((StatueAnimationFrame)sortedFrames.getLast()).getTick();
    }

    public boolean isLooping() {
        return this.loop;
    }

    public List<StatueAnimationFrame> getFrames() {
        return this.frames;
    }

    public int getDuration() {
        return this.duration;
    }

    public StatueAnimationFrame getNextFrame(StatueAnimationFrame frame) {
        if (!this.frames.contains(frame)) {
            throw new IllegalArgumentException("The frame isn't a part of this animation");
        }
        if (this.frames.indexOf(frame) >= this.frames.size() - 1) {
            return null;
        }
        return this.frames.get(this.frames.indexOf(frame) + 1);
    }

    public StatueAnimationFrame getPreviousFrame(StatueAnimationFrame frame) {
        if (!this.frames.contains(frame)) {
            throw new IllegalArgumentException("The frame isn't a part of this animation");
        }
        if (this.frames.indexOf(frame) <= 0) {
            return null;
        }
        return this.frames.get(this.frames.indexOf(frame) - 1);
    }

    public StatueAnimationFrame getFrameForProgress(int progress) {
        for (StatueAnimationFrame frame : this.frames) {
            if (this.getNextFrame(frame) == null) {
                return frame;
            }
            if (progress < frame.getTick() || progress >= this.getNextFrame(frame).getTick()) continue;
            return frame;
        }
        return null;
    }

    public StatueAnimationFrame getPreciseFrame(int tick) {
        return this.frames.stream().filter(f -> f.getTick() == tick).findAny().orElse(null);
    }

    public boolean doesFrameExist(int tick) {
        return this.getPreciseFrame(tick) != null;
    }

    public void updateFrame(int tick, StatueAnimationFrame frame) {
        int index = this.frames.indexOf(this.getPreciseFrame(tick));
        if (index == -1) {
            return;
        }
        this.frames.set(index, frame);
    }

    public void deleteFrame(StatueAnimationFrame frame) {
        this.frames.remove(frame);
    }
}

