/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.mojang.serialization.Codec;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.GlobalLogisticsManager;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

public enum NetworkDestructionLevel implements StringRepresentable
{
    ALL((network, player) -> true),
    MEMBERS((arg_0, arg_1) -> ((GlobalLogisticsManager)Create.LOGISTICS).mayInteract(arg_0, arg_1)),
    ADMINS((arg_0, arg_1) -> ((GlobalLogisticsManager)Create.LOGISTICS).mayAdministrate(arg_0, arg_1));

    public static final Codec<NetworkDestructionLevel> CODEC;
    public static final IntFunction<NetworkDestructionLevel> BY_ID;
    public static final StreamCodec<ByteBuf, NetworkDestructionLevel> STREAM_CODEC;
    private final BiPredicate<UUID, Player> canDestroy;

    private NetworkDestructionLevel(BiPredicate<UUID, Player> canDestroy) {
        this.canDestroy = canDestroy;
    }

    public NetworkDestructionLevel next() {
        int nextOrdinal = (this.ordinal() + 1) % NetworkDestructionLevel.values().length;
        return NetworkDestructionLevel.values()[nextOrdinal];
    }

    public boolean canDestroy(UUID networkId, Player player) {
        return this.canDestroy.test(networkId, player);
    }

    public Component getName() {
        return CreateQOLLang.translate("gui.stock_manager.destruction_level." + this.getSerializedName(), new Object[0]).component();
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromValues(NetworkDestructionLevel::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])NetworkDestructionLevel.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

