/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum ShadowRadianceEffects implements StringRepresentable
{
    NIGHT_VISION((Holder<MobEffect>)MobEffects.NIGHT_VISION, ArmorItem.Type.HELMET),
    INVISIBILITY((Holder<MobEffect>)MobEffects.INVISIBILITY, ArmorItem.Type.HELMET),
    STRENGTH((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, ArmorItem.Type.CHESTPLATE),
    REGENERATION((Holder<MobEffect>)MobEffects.REGENERATION, ArmorItem.Type.CHESTPLATE),
    SATURATION((Holder<MobEffect>)MobEffects.SATURATION, ArmorItem.Type.LEGGINGS),
    SPEED((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, ArmorItem.Type.LEGGINGS),
    JUMP_BOOST((Holder<MobEffect>)MobEffects.JUMP, ArmorItem.Type.BOOTS),
    HASTE((Holder<MobEffect>)MobEffects.DIG_SPEED, ArmorItem.Type.BOOTS);

    public static final Codec<ShadowRadianceEffects> CODEC;
    public static final IntFunction<ShadowRadianceEffects> BY_ID;
    public static final StreamCodec<ByteBuf, ShadowRadianceEffects> STREAM_CODEC;
    private final Holder<MobEffect> effectHolder;
    private final ArmorItem.Type type;

    private ShadowRadianceEffects(Holder<MobEffect> effectHolder, ArmorItem.Type type) {
        this.effectHolder = effectHolder;
        this.type = type;
    }

    public Holder<MobEffect> getEffectHolder() {
        return this.effectHolder;
    }

    public ArmorItem.Type getType() {
        return this.type;
    }

    public boolean isValidForItem(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof ArmorItem)) {
            return false;
        }
        ArmorItem it = (ArmorItem)item;
        return it.getType().equals((Object)this.getType());
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromValues(ShadowRadianceEffects::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ShadowRadianceEffects.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

