/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend.behaviours;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.packets.BlockEntityBehaviourConfigurationPacket;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SliderStylePriceConfigurationPacket
extends BlockEntityBehaviourConfigurationPacket<SliderStylePriceBehaviour> {
    public static final StreamCodec<FriendlyByteBuf, SliderStylePriceConfigurationPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, i -> i.pos, (StreamCodec)CatnipStreamCodecBuilders.array((StreamCodec)ByteBufCodecs.INT, Integer.class), i -> i.prices, SliderStylePriceConfigurationPacket::new);
    private final Integer[] prices;

    @Override
    protected BehaviourType<SliderStylePriceBehaviour> getType() {
        return SliderStylePriceBehaviour.TYPE;
    }

    public SliderStylePriceConfigurationPacket(BlockPos pos, Integer[] prices) {
        super(pos);
        this.prices = prices;
    }

    public SliderStylePriceConfigurationPacket(SyncedBlockEntity be) {
        super(be.getBlockPos());
        this.prices = new Integer[Coin.values().length];
        SliderStylePriceBehaviour priceBehaviour = (SliderStylePriceBehaviour)BlockEntityBehaviour.get((BlockEntity)be, this.getType());
        for (Coin coin : Coin.values()) {
            this.prices[coin.ordinal()] = priceBehaviour.getPrice(coin);
        }
    }

    @Override
    protected void applySettings(ServerPlayer player, SliderStylePriceBehaviour priceBehaviour) {
        for (Coin coin : Coin.values()) {
            priceBehaviour.setPrice(coin, this.prices[coin.ordinal()]);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return NumismaticsPackets.SLIDER_STYLE_PRICE_CONFIGURATION;
    }
}

