/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend.trust_list;

import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TrustListContainer
extends SimpleContainer {
    private final List<UUID> trustList;
    private final Runnable changeNotifier;

    public TrustListContainer(List<UUID> trustList, Runnable changeNotifier) {
        super(27);
        this.trustList = trustList;
        this.changeNotifier = changeNotifier;
    }

    public void setChanged() {
        this.trustList.clear();
        for (ItemStack stack : this.items) {
            UUID id = IDCardItem.get(stack);
            if (id == null) continue;
            this.trustList.add(id);
        }
        this.changeNotifier.run();
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        return NumismaticsTags.AllItemTags.ID_CARDS.matches(stack) && IDCardItem.isBound(stack) && !this.trustList.contains(IDCardItem.get(stack));
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.items, (HolderLookup.Provider)registries);
        return tag;
    }

    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.items, (HolderLookup.Provider)registries);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 1;
    }
}

