/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import dev.ithundxr.createnumismatics.registry.packets.VarIntContainerSetDataPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VarIntDataContainerSynchronizer
implements ContainerSynchronizer {
    private final ContainerSynchronizer wrapped;
    private final ServerPlayerConnection connection;

    public VarIntDataContainerSynchronizer(ContainerSynchronizer wrapped, ServerPlayerConnection connection) {
        this.wrapped = wrapped;
        this.connection = connection;
    }

    public void sendInitialData(AbstractContainerMenu container, NonNullList<ItemStack> items, ItemStack carriedItem, int[] initialData) {
        this.connection.send((Packet)new ClientboundContainerSetContentPacket(container.containerId, container.incrementStateId(), items, carriedItem));
        for (int i = 0; i < initialData.length; ++i) {
            this.sendDataChange(container, i, initialData[i]);
        }
    }

    public void sendSlotChange(AbstractContainerMenu container, int slot, ItemStack itemStack) {
        this.wrapped.sendSlotChange(container, slot, itemStack);
    }

    public void sendCarriedChange(AbstractContainerMenu containerMenu, ItemStack stack) {
        this.wrapped.sendCarriedChange(containerMenu, stack);
    }

    public void sendDataChange(AbstractContainerMenu container, int id, int value) {
        CatnipServices.NETWORK.sendToClient(this.connection.getPlayer(), (CustomPacketPayload)new VarIntContainerSetDataPacket(container.containerId, id, value));
    }
}

