/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.mojang.datafixers.util.Pair;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.MergingCoinBag;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotOutputMergingCoinBag
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private final MergingCoinBag coinBag;
    private final Coin coin;

    public SlotOutputMergingCoinBag(MergingCoinBag coinBag, Coin coin, int x, int y) {
        super(emptyInventory, 0, x, y);
        this.coinBag = coinBag;
        this.coin = coin;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack getItem() {
        return this.coinBag.asVisualStack(this.coin);
    }

    public void set(@NotNull ItemStack stack) {
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return this.getMaxStackSize();
    }

    public boolean mayPickup(@NotNull Player player) {
        return (Integer)this.coinBag.get(this.coin).getFirst() > 0;
    }

    protected void onSwapCraft(int numItemsCrafted) {
        this.remove(numItemsCrafted);
    }

    @NotNull
    public ItemStack remove(int amount) {
        int available = (Integer)this.coinBag.get(this.coin).getFirst();
        if ((amount = Math.min(amount, available)) <= 0) {
            return ItemStack.EMPTY;
        }
        this.coinBag.subtract(this.coin, amount);
        return this.coin.asStack(amount);
    }

    @NotNull
    public Optional<ItemStack> tryRemove(int count, int decrement, Player player) {
        decrement = Math.min(64, decrement);
        if (!this.mayPickup(player)) {
            return Optional.empty();
        }
        ItemStack itemStack = this.remove(count = Math.min(count, decrement));
        if (itemStack.isEmpty()) {
            return Optional.empty();
        }
        if (this.getItem().isEmpty()) {
            this.set(ItemStack.EMPTY);
        }
        return Optional.of(itemStack);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)Numismatics.asResource("item/coin/outline/" + this.coin.getName()));
    }
}

