/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlock;
import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.registry.packets.OpenTrustListPacket;
import dev.ithundxr.createnumismatics.util.ItemUtil;
import dev.ithundxr.createnumismatics.util.TextUtils;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import dev.ithundxr.createnumismatics.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendorBlockEntity
extends SmartBlockEntity
implements Trusted,
TrustListHolder,
IHaveHoveringInformation,
WorldlyContainer,
MenuProvider {
    private static final ItemStack BARRIER_STACK = new ItemStack((ItemLike)Items.BARRIER);
    public final Container cardContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            VendorBlockEntity.this.setChanged();
        }
    };
    public final Container sellingContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            VendorBlockEntity.this.setChanged();
            VendorBlockEntity.this.correctStock();
        }
    };
    @Nullable
    protected UUID owner;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, () -> ((VendorBlockEntity)this).setChanged());
    protected final DiscreteCoinBag inventory = new DiscreteCoinBag();
    private boolean delayedDataSync = false;
    private SliderStylePriceBehaviour price;
    private Mode mode = Mode.SELL;
    public final NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    @Nullable
    private Boolean isCreativeVendorCached;

    public VendorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.price = new SliderStylePriceBehaviour(this, this::addCoin, this::getCoinCount);
        behaviours.add(this.price);
    }

    public int getCoinCount(Coin coin) {
        return this.inventory.getDiscrete(coin);
    }

    @Nullable
    public UUID getCardId() {
        ItemStack card = this.cardContainer.getItem(0);
        if (!(card.getItem() instanceof CardItem)) {
            return null;
        }
        return CardItem.get(card);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.owner != null) {
            tag.putUUID("Owner", this.owner);
        }
        if (!this.inventory.isEmpty()) {
            tag.put("CoinInventory", (Tag)this.inventory.save(new CompoundTag()));
        }
        if (!this.cardContainer.getItem(0).isEmpty()) {
            tag.put("Card", this.cardContainer.getItem(0).save(registries));
        }
        if (!this.getSellingItem().isEmpty()) {
            tag.put("Selling", this.getSellingItem().save(registries));
        }
        if (!this.trustListContainer.isEmpty()) {
            tag.put("TrustListInv", (Tag)this.trustListContainer.save(new CompoundTag(), registries));
        }
        if (!this.items.isEmpty()) {
            tag.put("Inventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.items, (HolderLookup.Provider)registries));
        }
        tag.putInt("Mode", this.mode.ordinal());
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.owner = tag.hasUUID("Owner") ? tag.getUUID("Owner") : null;
        this.inventory.clear();
        if (tag.contains("CoinInventory", 10)) {
            this.inventory.load(tag.getCompound("CoinInventory"));
        }
        this.cardContainer.setItem(0, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Card")));
        this.sellingContainer.setItem(0, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Selling")));
        this.trustListContainer.clearContent();
        this.trustList.clear();
        if (tag.contains("TrustListInv", 10)) {
            this.trustListContainer.load(tag.getCompound("TrustListInv"), registries);
        }
        this.items.clear();
        if (tag.contains("Inventory", 10)) {
            ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("Inventory"), this.items, (HolderLookup.Provider)registries);
        }
        this.mode = Mode.values()[tag.getInt("Mode")];
    }

    /*
     * Unable to fully structure code
     */
    public boolean isCreativeVendor() {
        block2: {
            if (this.isCreativeVendorCached != null) break block2;
            var2_1 = this.getBlockState().getBlock();
            if (!(var2_1 instanceof VendorBlock)) ** GOTO lbl-1000
            vendorBlock = (VendorBlock)var2_1;
            if (vendorBlock.isCreativeVendor) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.isCreativeVendorCached = v0;
        }
        return this.isCreativeVendorCached;
    }

    @Override
    public boolean isTrustedInternal(Player player) {
        if (Utils.isDevEnv()) {
            return player.getItemBySlot(EquipmentSlot.FEET).is(Items.GOLDEN_BOOTS);
        }
        if (this.isCreativeVendor()) {
            return player != null && player.isCreative();
        }
        return this.owner == null || this.owner.equals(player.getUUID()) || this.trustList.contains(player.getUUID());
    }

    public void addCoin(Coin coin, int count) {
        BankAccount account;
        UUID depositAccount = this.getDepositAccount();
        if (depositAccount != null && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            account.deposit(coin, count);
            return;
        }
        this.inventory.add(coin, count);
        this.setChanged();
    }

    @Nullable
    public UUID getDepositAccount() {
        ItemStack cardStack = this.cardContainer.getItem(0);
        if (cardStack.isEmpty()) {
            return null;
        }
        if (!NumismaticsTags.AllItemTags.CARDS.matches(cardStack)) {
            return null;
        }
        return CardItem.get(cardStack);
    }

    public void lazyTick() {
        BankAccount account;
        UUID depositAccount;
        super.lazyTick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if ((depositAccount = this.getDepositAccount()) != null && !this.inventory.isEmpty() && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            for (Coin coin : Coin.values()) {
                int count = this.inventory.getDiscrete(coin);
                this.inventory.subtract(coin, count);
                account.deposit(coin, count);
                this.notifyUpdate();
            }
        }
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public Container getTrustListBackingContainer() {
        return this.trustListContainer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ItemStack sellingStack = this.getSellingItem();
        if (sellingStack.isEmpty()) {
            return false;
        }
        switch (this.mode.ordinal()) {
            case 0: {
                if (this.hasStock()) break;
                Lang.builder((String)"numismatics").add(Component.translatable((String)"gui.numismatics.vendor.out_of_stock")).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                if (ownerName == null) break;
                Lang.builder((String)"numismatics").add(Component.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                break;
            }
            case 1: {
                String ownerName;
                if (!this.hasSpace()) {
                    Lang.builder((String)"numismatics").add(Component.translatable((String)"gui.numismatics.vendor.full")).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                    ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                    if (ownerName == null) break;
                    Lang.builder((String)"numismatics").add(Component.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                    break;
                }
                if (this.hasEnoughMoney()) break;
                Lang.builder((String)"numismatics").add(Component.translatable((String)"gui.numismatics.vendor.insufficient_funds")).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                if (ownerName == null) break;
                Lang.builder((String)"numismatics").add(Component.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            }
        }
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(this.getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        MutableComponent balanceLabel = Component.translatable((String)"block.numismatics.vendor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        Lang.builder((String)"numismatics").add(Component.translatable((String)this.mode.getOpposite().getActionTranslationKey())).forGoggles(tooltip);
        boolean isFirst = true;
        for (Component component : Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)sellingStack)) {
            MutableComponent mutable = component.copy();
            if (isFirst) {
                isFirst = false;
                if (sellingStack.getCount() != 1) {
                    mutable.append((Component)Component.translatable((String)"gui.numismatics.vendor.count", (Object[])new Object[]{sellingStack.getCount()}).withStyle(ChatFormatting.GREEN));
                }
            }
            Lang.builder((String)"numismatics").add(mutable).forGoggles(tooltip);
        }
        tooltip.add(CommonComponents.EMPTY);
        Lang.builder((String)"numismatics").add(balanceLabel.withStyle(Coin.closest((int)this.getTotalPrice()).rarity.color())).forGoggles(tooltip);
        for (MutableComponent mutableComponent : this.price.getCondensedPriceBreakdown()) {
            Lang.builder((String)"numismatics").add(mutableComponent).forGoggles(tooltip);
        }
        return true;
    }

    public ItemStack getIcon(boolean isPlayerSneaking) {
        return this.getSellingItem().isEmpty() ? BARRIER_STACK : this.getSellingItem();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)(this.isCreativeVendor() ? "block.numismatics.creative_vendor" : "block.numismatics.vendor"));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new VendorMenu((MenuType)NumismaticsMenuTypes.VENDOR.get(), i, inventory, this);
    }

    public int getTotalPrice() {
        return this.price.getTotalPrice();
    }

    public int getPrice(Coin coin) {
        return this.price.getPrice(coin);
    }

    public void setPrice(Coin coin, int price) {
        this.price.setPrice(coin, price);
    }

    public ItemStack getSellingItem() {
        return this.sellingContainer.getItem(0);
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        return this.mode == Mode.SELL && this.matchesSellingItem(stack);
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return this.mode == Mode.BUY;
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(slot, (Object)ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    @NotNull
    @Contract(value="_ -> new")
    private PatchedDataComponentMap cleanComponents(@NotNull DataComponentMap dataComponents) {
        PatchedDataComponentMap map = new PatchedDataComponentMap(dataComponents);
        map.remove(DataComponents.REPAIR_COST);
        return map;
    }

    public boolean matchesSellingItem(@NotNull ItemStack b) {
        ItemStack a = this.getSellingItem();
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        if (!ItemStack.isSameItem((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        DataComponentMap an = a.getComponents();
        DataComponentMap bn = b.getComponents();
        an = this.cleanComponents(an);
        bn = this.cleanComponents(bn);
        return an.equals((Object)bn);
    }

    protected void condenseItems() {
        NonNullList newItems = NonNullList.withSize((int)this.items.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.items.size(); ++i) {
            newItems.set(i, (Object)((ItemStack)this.items.get(i)));
        }
        this.items.clear();
        for (ItemStack stack : newItems) {
            ItemUtil.moveItemStackTo(stack, (Container)this, false);
        }
        this.notifyUpdate();
    }

    protected void correctStock() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (this.matchesSellingItem(stack) || stack.isEmpty() || this.level == null) continue;
            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ(), (ItemStack)stack);
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
        this.notifyUpdate();
    }

    public void dropContents(Level level, BlockPos pos) {
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)this);
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)this.cardContainer);
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)this.sellingContainer);
        this.inventory.dropContents(level, pos);
    }

    private boolean hasStock() {
        if (this.isCreativeVendor()) {
            return true;
        }
        for (ItemStack stack : this.items) {
            if (!this.matchesSellingItem(stack) || stack.getCount() < this.getSellingItem().getCount()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSpace() {
        if (this.isCreativeVendor()) {
            return true;
        }
        ItemStack buying = this.getSellingItem();
        int space = 0;
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) {
                space += buying.getMaxStackSize();
                continue;
            }
            if (!this.matchesSellingItem(stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
            space += stack.getMaxStackSize() - stack.getCount();
        }
        return space >= buying.getCount();
    }

    private boolean hasEnoughMoney() {
        if (this.isCreativeVendor()) {
            return true;
        }
        if (this.price.canPayOut()) {
            return true;
        }
        if (this.getCardId() != null) {
            BankAccount account = Numismatics.BANK.getAccount(this.getCardId());
            return account != null && account.isAuthorized(this.owner) && account.getBalance() >= this.price.getTotalPrice();
        }
        return false;
    }

    public void tryTransaction(Player player, InteractionHand hand) {
        switch (this.mode.ordinal()) {
            case 0: {
                this.trySellTo(player, hand);
                break;
            }
            case 1: {
                this.tryBuyFrom(player, hand);
            }
        }
    }

    private void trySellTo(Player player, InteractionHand hand) {
        if (this.level == null) {
            return;
        }
        ItemStack selling = this.getSellingItem();
        if (selling.isEmpty()) {
            return;
        }
        this.condenseItems();
        if (this.isCreativeVendor()) {
            if (this.price.deduct(player, hand, false)) {
                ItemStack output = selling.copy();
                ItemUtil.givePlayerItem(player, output);
                this.giveSellingAdvancements(player);
                this.level.playSound(null, this.getBlockPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.BLOCKS, 0.5f, 1.0f);
                this.notifyUpdate();
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.insufficient_funds").withStyle(ChatFormatting.DARK_RED), true);
                this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        } else {
            for (ItemStack stack : this.items) {
                if (!this.matchesSellingItem(stack) || stack.getCount() < selling.getCount()) continue;
                if (this.price.deduct(player, hand, true)) {
                    ItemStack output = stack.split(selling.getCount());
                    ItemUtil.givePlayerItem(player, output);
                    this.giveSellingAdvancements(player);
                    this.level.playSound(null, this.getBlockPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.BLOCKS, 0.5f, 1.0f);
                    this.notifyUpdate();
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.insufficient_funds").withStyle(ChatFormatting.DARK_RED), true);
                    this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                return;
            }
            String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
            if (ownerName != null) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.out_of_stock.named", (Object[])new Object[]{ownerName}).withStyle(ChatFormatting.DARK_RED), true);
                this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.out_of_stock").withStyle(ChatFormatting.DARK_RED), true);
                this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
    }

    private void giveSellingAdvancements(Player player) {
        ItemStack selling = this.getSellingItem();
        Item item = selling.getItem();
        if (item instanceof CoinItem) {
            CoinItem coin = (CoinItem)item;
            NumismaticsAdvancements.MONEY_LAUNDERING.awardTo(player);
            int soldValue = coin.coin.toSpurs(selling.getCount());
            int paidValue = this.price.getTotalPrice();
            if (soldValue > paidValue) {
                NumismaticsAdvancements.IS_THIS_LEGAL.awardTo(player);
            } else if (soldValue < paidValue) {
                NumismaticsAdvancements.QUESTIONABLE_INVESTMENT.awardTo(player);
            }
        }
    }

    private void tryBuyFrom(Player player, InteractionHand hand) {
        BankAccount account;
        if (this.level == null) {
            return;
        }
        ItemStack buying = this.getSellingItem();
        if (buying.isEmpty()) {
            return;
        }
        ItemStack handStack = player.getItemInHand(hand);
        if (handStack.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.no_item_in_hand").withStyle(ChatFormatting.DARK_RED), true);
            this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return;
        }
        if (!this.matchesSellingItem(handStack)) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.incorrect_item").withStyle(ChatFormatting.DARK_RED), true);
            this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return;
        }
        if (handStack.getCount() < buying.getCount()) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.too_few_items").withStyle(ChatFormatting.DARK_RED), true);
            this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return;
        }
        if (!this.hasSpace()) {
            String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
            if (ownerName != null) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.full.named", (Object[])new Object[]{ownerName}).withStyle(ChatFormatting.DARK_RED), true);
                this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.full").withStyle(ChatFormatting.DARK_RED), true);
                this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return;
        }
        if (this.isCreativeVendor() || this.price.canPayOut()) {
            handStack.shrink(buying.getCount());
            player.setItemInHand(hand, handStack);
            this.addBoughtItem(buying.copy());
            if (!this.isCreativeVendor()) {
                this.price.deductFromSelf(false);
            }
            this.price.pay(player);
            this.level.playSound(null, this.getBlockPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.notifyUpdate();
            return;
        }
        if (this.getCardId() != null && (account = Numismatics.BANK.getAccount(this.getCardId())) != null && account.isAuthorized(this.owner) && account.deduct(this.price.getTotalPrice())) {
            handStack.shrink(buying.getCount());
            player.setItemInHand(hand, handStack);
            this.addBoughtItem(buying.copy());
            this.price.pay(player);
            this.level.playSound(null, this.getBlockPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.notifyUpdate();
            return;
        }
        String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
        if (ownerName != null) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.insufficient_funds.named", (Object[])new Object[]{ownerName}).withStyle(ChatFormatting.DARK_RED), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.insufficient_funds").withStyle(ChatFormatting.DARK_RED), true);
        }
        this.level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private void addBoughtItem(ItemStack stack) {
        if (!this.matchesSellingItem(stack)) {
            return;
        }
        if (this.isCreativeVendor()) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (item.isEmpty() || this.matchesSellingItem(item)) {
                if (item.getCount() + stack.getCount() <= item.getMaxStackSize()) {
                    this.items.set(i, (Object)this.getSellingItem().copyWithCount(item.getCount() + stack.getCount()));
                    return;
                }
                int diff = item.getMaxStackSize() - item.getCount();
                this.items.set(i, (Object)this.getSellingItem().copyWithCount(item.getMaxStackSize()));
                stack.shrink(diff);
            }
            if (stack.isEmpty()) break;
        }
        this.notifyUpdate();
    }

    @Override
    public void openTrustListMenu(ServerPlayer player) {
        TrustListMenu.openMenu(this, player, this.isCreativeVendor() ? NumismaticsBlocks.CREATIVE_VENDOR.asStack() : NumismaticsBlocks.VENDOR.asStack());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openTrustList() {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        CatnipServices.NETWORK.sendToServer(new OpenTrustListPacket(this.getBlockPos()));
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
        }
    }

    public static enum Mode {
        SELL,
        BUY;

        public static final StreamCodec<ByteBuf, Mode> STREAM_CODEC;

        public static List<Component> getComponents() {
            return ImmutableList.copyOf(Arrays.stream(Mode.values()).map(Mode::getTranslationKey).map(Component::translatable).iterator());
        }

        public String getTranslationKey() {
            return "gui.numismatics.vendor.mode." + this.name().toLowerCase(Locale.ROOT);
        }

        public String getActionTranslationKey() {
            return this.getTranslationKey() + ".action";
        }

        public Mode getOpposite() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> BUY;
                case 1 -> SELL;
            };
        }

        static {
            STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(Mode.class);
        }
    }
}

