/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBlock;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class StirlingEngineRenderer
extends SafeBlockEntityRenderer<StirlingEngineBE> {
    public StirlingEngineRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(StirlingEngineBE be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        Float angle = be.getTargetAngle();
        if (angle == null) {
            return;
        }
        BlockState state = be.getBlockState();
        VertexConsumer vb = bufferSource.getBuffer(RenderType.solid());
        Direction facing = StirlingEngineBlock.getFacing(state);
        float angle2 = AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing));
        ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)DesiresPartialModels.FRAME, (BlockState)state).rotateCentered(angle2, Direction.UP)).translate(0.0f, 0.0f, -1.0f)).light(light).renderInto(ms, vb);
        Direction.Axis facingAxis = facing.getAxis();
        boolean roll90 = !facingAxis.isHorizontal();
        float sine = Mth.sin((float)angle.floatValue());
        float sine2 = Mth.sin((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        ((SuperByteBuffer)this.transformed(DesiresPartialModels.ENGINE_PISTON, state, facing, roll90).translate(0.0f, piston, 0.0f)).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(DesiresPartialModels.ENGINE_LINKAGE, state, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f)).uncenter()).translate(0.0f, piston, 0.0f)).translate(0.0f, 0.25f, 0.5f)).rotateXDegrees(sine2 * 23.0f)).translate(0.0f, -0.25f, -0.5f)).light(light).renderInto(ms, vb);
    }

    private SuperByteBuffer transformed(PartialModel model, BlockState blockState, Direction facing, boolean roll90) {
        return (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)model, (BlockState)blockState).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing) + 90.0f)).rotateYDegrees(roll90 ? -90.0f : 0.0f)).uncenter();
    }

    public int getViewDistance() {
        return 128;
    }
}

