/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBlock;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StirlingEngineValueBox
extends ValueBoxTransform.Sided {
    protected boolean isSideActive(BlockState state, Direction side) {
        boolean recessed;
        Direction engineFacing = StirlingEngineBlock.getFacing(state);
        if (engineFacing.getAxis() == side.getAxis()) {
            return false;
        }
        int roll = 0;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(engineFacing) != side) continue;
            roll = p.getXRotation();
        }
        if (engineFacing == Direction.UP) {
            roll += 180;
        }
        boolean bl = recessed = roll % 180 == 0;
        if (engineFacing.getAxis() == Direction.Axis.Y) {
            recessed ^= ((Direction)state.getValue((Property)StirlingEngineBlock.FACING)).getAxis() == Direction.Axis.X;
        }
        return !recessed;
    }

    public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction side = this.getSide();
        Direction engineFacing = StirlingEngineBlock.getFacing(state);
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(engineFacing) != side) continue;
            roll = p.getXRotation();
        }
        if (engineFacing == Direction.UP) {
            roll += 180.0f;
        }
        float horizontalAngle = AngleHelper.horizontalAngle((Direction)engineFacing);
        float verticalAngle = AngleHelper.verticalAngle((Direction)engineFacing);
        Vec3 local = VecHelper.voxelSpace((double)8.0, (double)14.75, (double)4.0);
        local = VecHelper.rotateCentered((Vec3)local, (double)roll, (Direction.Axis)Direction.Axis.Z);
        local = VecHelper.rotateCentered((Vec3)local, (double)horizontalAngle, (Direction.Axis)Direction.Axis.Y);
        local = VecHelper.rotateCentered((Vec3)local, (double)verticalAngle, (Direction.Axis)Direction.Axis.X);
        return local;
    }

    public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        Direction facing = StirlingEngineBlock.getFacing(state);
        if (facing.getAxis() == Direction.Axis.Y) {
            super.rotate(level, pos, state, ms);
            return;
        }
        int roll = 0;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(facing) != this.getSide()) continue;
            roll = p.getXRotation();
        }
        float yRot = AngleHelper.horizontalAngle((Direction)facing) + (float)(facing == Direction.DOWN ? 180 : 0);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(facing == Direction.DOWN ? -90.0f : 90.0f)).rotateYDegrees((float)roll);
    }

    protected Vec3 getSouthLocation() {
        return Vec3.ZERO;
    }
}

