/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.logistics.fluid_hatch;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.lopyluna.dndesires.content.blocks.logistics.fluid_hatch.FluidHatchBE;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import dev.lopyluna.dndesires.register.DesiresSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FluidHatchBlock
extends HorizontalDirectionalBlock
implements IBE<FluidHatchBE>,
IWrenchable,
ProperWaterloggedBlock {
    public static final MapCodec<FluidHatchBlock> CODEC = FluidHatchBlock.simpleCodec(FluidHatchBlock::new);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public FluidHatchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{OPEN, FACING, WATERLOGGED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        if (state == null) {
            return null;
        }
        if (pContext.getClickedFace().getAxis().isVertical()) {
            return null;
        }
        return this.withWater((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)pContext.getClickedFace().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), pContext);
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pPos);
        return pState;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean depositItemInHand;
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return ItemInteractionResult.SUCCESS;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(facing);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity == null) {
            return ItemInteractionResult.FAIL;
        }
        IFluidHandler targetInv = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos, (Object)facing);
        if (targetInv == null) {
            return ItemInteractionResult.FAIL;
        }
        FilteringBehaviour filter = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)FilteringBehaviour.TYPE);
        if (filter == null) {
            return ItemInteractionResult.FAIL;
        }
        Inventory inventory = player.getInventory();
        boolean anyInserted = false;
        boolean bl = depositItemInHand = !player.isShiftKeyDown();
        if (!depositItemInHand && AllTags.AllItemTags.WRENCH.matches(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        for (int i = 0; i < inventory.items.size(); ++i) {
            Pair emptyingResult;
            FluidStack fluidStack;
            ItemStack item;
            if (Inventory.isHotbarSlot((int)i) != depositItemInHand || depositItemInHand && i != inventory.selected || (item = inventory.getItem(i)).isEmpty() || !GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)item) || (fluidStack = (FluidStack)(emptyingResult = GenericItemEmptying.emptyItem((Level)level, (ItemStack)item, (boolean)true)).getFirst()).isEmpty() || !filter.test(fluidStack) || fluidStack.getAmount() != targetInv.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) || level.isClientSide) continue;
            ItemStack copyOfItem = item.copy();
            emptyingResult = GenericItemEmptying.emptyItem((Level)level, (ItemStack)copyOfItem, (boolean)false);
            targetInv.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            if (!player.isCreative() && !(blockEntity instanceof CreativeFluidTankBlockEntity)) {
                if (copyOfItem.isEmpty()) {
                    inventory.setItem(i, (ItemStack)emptyingResult.getSecond());
                } else {
                    inventory.setItem(i, copyOfItem);
                    inventory.placeItemBackInInventory((ItemStack)emptyingResult.getSecond());
                }
            }
            anyInserted = true;
        }
        if (!anyInserted) {
            return ItemInteractionResult.SUCCESS;
        }
        DesiresSoundEvents.FLUID_HATCH.playOnServer(level, (Vec3i)pos);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)));
        level.scheduleTick(pos, (Block)this, 10);
        CreateLang.translate((String)(depositItemInHand ? "item_hatch.deposit_item" : "item_hatch.deposit_inventory"), (Object[])new Object[0]).sendStatus(player);
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.ITEM_HATCH.get(((Direction)pState.getValue((Property)FACING)).getOpposite());
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)OPEN)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<FluidHatchBE> getBlockEntityClass() {
        return FluidHatchBE.class;
    }

    public BlockEntityType<? extends FluidHatchBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.FLUID_HATCH.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

