/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.logistics.smart_hopper;

import com.simibubi.create.content.logistics.chute.SmartChuteBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.lopyluna.dndesires.content.blocks.logistics.smart_hopper.HopperInventory;
import dev.lopyluna.dndesires.content.blocks.logistics.smart_hopper.SmartHopperBlock;
import dev.lopyluna.dndesires.content.blocks.logistics.smart_hopper.SmartHopperFilterSlotPositioning;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartHopperBE
extends SmartBlockEntity
implements MenuProvider {
    HopperInventory inv;
    FilteringBehaviour filtering;
    VersionedInventoryTrackerBehaviour invVersionTracker;
    private final EnumMap<Direction, BlockCapabilityCache<IItemHandler, @Nullable Direction>> capCaches = new EnumMap(Direction.class);

    public SmartHopperBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inv = new HopperInventory(5, this);
        this.setLazyTickRate(8);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)DesiresBETypes.SMART_HOPPER.get(), (be, context) -> be.inv);
    }

    public void lazyTick() {
        boolean clientSide;
        super.lazyTick();
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)SmartHopperBlock.FACING);
        boolean bl = clientSide = this.level.isClientSide && !this.isVirtual();
        if (this.inv != null) {
            IItemHandler output;
            if (!clientSide) {
                this.suckInItems(state, this.level);
                this.handleInput(this.grabCapability(Direction.UP), state);
            }
            if (this.handleOutput(output = this.grabCapability(facing), state, true)) {
                this.handleOutput(output, state, clientSide);
            }
        }
    }

    private void handleInput(@Nullable IItemHandler inv, BlockState state) {
        ItemStack extracted;
        if (inv == null) {
            return;
        }
        if (this.cantActivate(state)) {
            return;
        }
        if (this.invVersionTracker.stillWaiting(inv)) {
            return;
        }
        Predicate<ItemStack> canAccept = s -> !this.cantAcceptItem((ItemStack)s, state);
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (!(mode != ItemHelper.ExtractionCountMode.UPTO && ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)true).isEmpty() || (extracted = ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)false)).isEmpty())) {
            this.insertItem(extracted, false);
            return;
        }
        this.invVersionTracker.awaitNewVersion(inv);
    }

    private boolean handleOutput(IItemHandler inv, BlockState state, boolean simulate) {
        assert (this.level != null);
        if (this.cantActivate(state)) {
            return false;
        }
        if (inv != null) {
            if (this.level.isClientSide && !this.isVirtual()) {
                return false;
            }
            if (this.invVersionTracker.stillWaiting(inv)) {
                return false;
            }
            ItemStack extracted = ItemHelper.extract((IItemHandler)this.inv, s -> this.filtering.test(s), (boolean)simulate);
            if (extracted.isEmpty()) {
                return false;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)extracted, (boolean)simulate);
            if (!simulate) {
                this.insertItem(remainder, false);
            }
            if (remainder.getCount() != extracted.getCount()) {
                return true;
            }
            this.invVersionTracker.awaitNewVersion(inv);
        }
        return true;
    }

    public void insertItem(ItemStack stack, boolean simulate) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.inv, (ItemStack)stack, (boolean)simulate);
        this.invVersionTracker.reset();
        assert (this.level != null);
        if (!this.level.isClientSide) {
            this.notifyUpdate();
        }
    }

    @Nullable
    private IItemHandler grabCapability(@NotNull Direction side) {
        BlockPos pos = this.worldPosition.relative(side);
        if (this.level == null) {
            return null;
        }
        if (this.capCaches.get(side) == null) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockCapabilityCache cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)pos, (Object)side.getOpposite());
                this.capCaches.put(side, (BlockCapabilityCache<IItemHandler, Direction>)cache);
                return (IItemHandler)cache.getCapability();
            }
            return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side.getOpposite());
        }
        return (IItemHandler)this.capCaches.get(side).getCapability();
    }

    protected boolean cantAcceptItem(ItemStack stack, BlockState state) {
        return ItemStack.isSameItemSameComponents((ItemStack)ItemHandlerHelper.insertItem((IItemHandler)this.inv, (ItemStack)stack.copy(), (boolean)true), (ItemStack)stack) || this.cantActivate(state) || !this.filtering.test(stack);
    }

    protected boolean cantActivate(BlockState state) {
        return state.hasProperty((Property)SmartChuteBlock.POWERED) && (Boolean)state.getValue((Property)SmartChuteBlock.POWERED) != false;
    }

    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SmartHopperFilterSlotPositioning()).showCount().withCallback($ -> this.invVersionTracker.reset());
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inv);
    }

    public void invalidate() {
        if (this.inv != null) {
            this.invalidateCapabilities();
        }
        this.capCaches.clear();
        super.invalidate();
    }

    public boolean isEmpty() {
        return this.inv.isEmpty();
    }

    public void setChanged() {
        super.setChanged();
        this.inv.setChanged();
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        this.inv.save(tag, registries);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.inv.load(tag, registries);
    }

    @NotNull
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        if (this.inv == null) {
            this.inv = new HopperInventory(5, this);
        }
        return new HopperMenu(id, inventory, (Container)this.inv);
    }

    public void suckInItems(BlockState state, Level level) {
        boolean flag;
        if (this.cantActivate(state)) {
            return;
        }
        BlockPos blockpos = BlockPos.containing((double)this.getLevelX(), (double)(this.getLevelY() + 1.0), (double)this.getLevelZ());
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos pos = this.getBlockPos();
        boolean bl = flag = !blockstate.isCollisionShapeFullBlock((BlockGetter)level, blockpos) || blockstate.is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
        if (flag) {
            for (ItemEntity entity : this.getItemsAtAndAbove(level)) {
                ItemStack stack = entity.getItem().copy();
                if (stack.isEmpty() || !entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())).intersects(SmartHopperBlock.SUCK_AABB) || this.cantAcceptItem(stack, state)) continue;
                entity.setItem(this.handleExtracting(stack, state));
            }
        }
    }

    public ItemStack handleExtracting(ItemStack stack, BlockState state) {
        int amountExtract;
        if (stack.isEmpty()) {
            return stack;
        }
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        ItemStack extract = this.extract(stack, state, mode, count, amountExtract = Math.min(count, stack.getCount()));
        if (ItemStack.isSameItemSameComponents((ItemStack)extract, (ItemStack)stack)) {
            return stack;
        }
        if (mode == ItemHelper.ExtractionCountMode.UPTO || !extract.isEmpty()) {
            int newCount = stack.getCount();
            newCount -= amountExtract;
            ItemStack leftOver = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inv, (ItemStack)extract, (boolean)false);
            return stack.copyWithCount(newCount += leftOver.getCount());
        }
        return stack;
    }

    public ItemStack extract(ItemStack itemStack, BlockState state, ItemHelper.ExtractionCountMode mode, int amount, int amountExtract) {
        ItemStack empty = ItemStack.EMPTY;
        ItemStack toExtract = ItemStack.EMPTY;
        boolean amountRequired = mode == ItemHelper.ExtractionCountMode.EXACTLY;
        toExtract = itemStack.copyWithCount(amountExtract);
        if (toExtract.isEmpty() || this.cantAcceptItem(toExtract, state)) {
            return empty;
        }
        if (amountRequired && toExtract.getCount() < amount) {
            return empty;
        }
        return toExtract;
    }

    public List<ItemEntity> getItemsAtAndAbove(Level level) {
        return level.getEntitiesOfClass(ItemEntity.class, SmartHopperBlock.SUCK_AABB.move(this.getLevelX() - 0.5, this.getLevelY() - 0.5, this.getLevelZ() - 0.5), EntitySelector.ENTITY_STILL_ALIVE);
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }
}

