/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.register;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import dev.lopyluna.dndesires.DesiresUtils;
import dev.lopyluna.dndesires.DnDesires;
import dev.lopyluna.dndesires.register.DesiresConfigs;
import dev.lopyluna.dndesires.register.DesiresStoneTypes;
import dev.lopyluna.dndesires.register.DesiresTags;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3f;

public class DesiresFluids {
    public static final FluidEntry<BaseFlowingFluid.Flowing> CHOCOLATE_MILKSHAKE = DesiresFluids.newFluid("Chocolate Milkshake", 11690317, () -> DesiresConfigs.client().chocolateTransparencyMultiplier).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> VANILLA_MILKSHAKE = DesiresFluids.newFluid("Vanilla Milkshake", 15588026, () -> DesiresConfigs.client().vanillaTransparencyMultiplier).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> STRAWBERRY_MILKSHAKE = DesiresFluids.newFluid("Strawberry Milkshake", 13990539, () -> DesiresConfigs.client().strawberryTransparencyMultiplier).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> GLOWBERRY_MILKSHAKE = DesiresFluids.newFluid("Glowberry Milkshake", 14197077, () -> DesiresConfigs.client().glowberryTransparencyMultiplier).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> PUMPKIN_MILKSHAKE = DesiresFluids.newFluid("Pumpkin Milkshake", 13335352, () -> DesiresConfigs.client().pumpkinTransparencyMultiplier).register();

    public static FluidBuilder<BaseFlowingFluid.Flowing, CreateRegistrate> newFluid(String name, int hexColor, Supplier<ConfigBase.ConfigFloat> type) {
        String id = name.toLowerCase().replace(" ", "_");
        return (FluidBuilder)DnDesires.REG.standardFluid(id, SolidRenderedPlaceableFluidType.create(hexColor, () -> Float.valueOf(0.25f * ((ConfigBase.ConfigFloat)type.get()).getF()))).lang(name).properties(b -> b.viscosity(1000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(10).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{DesiresTags.commonFluidTag(id + "s")}).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{DesiresTags.commonItemTag("buckets/" + id)}).build();
    }

    public static void register() {
    }

    public static void registerFluidInteractions() {
        DesiresFluids.addMilkshakeInteraction((Fluid)CHOCOLATE_MILKSHAKE.get(), (Block)AllPaletteStoneTypes.VERIDIUM.getBaseBlock().get(), Blocks.GRANITE);
        DesiresFluids.addMilkshakeInteraction((Fluid)VANILLA_MILKSHAKE.get(), (Block)AllPaletteStoneTypes.ASURINE.getBaseBlock().get(), Blocks.SANDSTONE);
        DesiresFluids.addMilkshakeInteraction((Fluid)STRAWBERRY_MILKSHAKE.get(), (Block)AllPaletteStoneTypes.CRIMSITE.getBaseBlock().get(), Blocks.COBBLED_DEEPSLATE);
        DesiresFluids.addMilkshakeInteraction((Fluid)GLOWBERRY_MILKSHAKE.get(), (Block)AllPaletteStoneTypes.OCHRUM.getBaseBlock().get(), Blocks.TERRACOTTA);
        DesiresFluids.addMilkshakeInteraction((Fluid)PUMPKIN_MILKSHAKE.get(), (Block)DesiresStoneTypes.BRECCIA.getBaseBlock().get(), (Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get());
    }

    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.getType();
        if (fluid.isSame((Fluid)CHOCOLATE_MILKSHAKE.get())) {
            return Blocks.GRANITE.defaultBlockState();
        }
        if (fluid.isSame((Fluid)VANILLA_MILKSHAKE.get())) {
            return Blocks.SANDSTONE.defaultBlockState();
        }
        if (fluid.isSame((Fluid)STRAWBERRY_MILKSHAKE.get())) {
            return Blocks.COBBLED_DEEPSLATE.defaultBlockState();
        }
        if (fluid.isSame((Fluid)GLOWBERRY_MILKSHAKE.get())) {
            return Blocks.TERRACOTTA.defaultBlockState();
        }
        if (fluid.isSame((Fluid)PUMPKIN_MILKSHAKE.get())) {
            return ((Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get()).defaultBlockState();
        }
        return null;
    }

    public static BlockState getInteractions(FluidState fluidState, Level level, BlockPos pos) {
        if (DesiresFluids.addMilkshakeFlag(fluidState, (Fluid)CHOCOLATE_MILKSHAKE.get(), level, pos)) {
            return DesiresFluids.addMilkshakeStones((Block)AllPaletteStoneTypes.VERIDIUM.getBaseBlock().get(), Blocks.GRANITE, level, pos);
        }
        if (DesiresFluids.addMilkshakeFlag(fluidState, (Fluid)VANILLA_MILKSHAKE.get(), level, pos)) {
            return DesiresFluids.addMilkshakeStones((Block)AllPaletteStoneTypes.ASURINE.getBaseBlock().get(), Blocks.SANDSTONE, level, pos);
        }
        if (DesiresFluids.addMilkshakeFlag(fluidState, (Fluid)STRAWBERRY_MILKSHAKE.get(), level, pos)) {
            return DesiresFluids.addMilkshakeStones((Block)AllPaletteStoneTypes.CRIMSITE.getBaseBlock().get(), Blocks.COBBLED_DEEPSLATE, level, pos);
        }
        if (DesiresFluids.addMilkshakeFlag(fluidState, (Fluid)GLOWBERRY_MILKSHAKE.get(), level, pos)) {
            return DesiresFluids.addMilkshakeStones((Block)AllPaletteStoneTypes.OCHRUM.getBaseBlock().get(), Blocks.TERRACOTTA, level, pos);
        }
        if (DesiresFluids.addMilkshakeFlag(fluidState, (Fluid)PUMPKIN_MILKSHAKE.get(), level, pos)) {
            return DesiresFluids.addMilkshakeStones((Block)DesiresStoneTypes.BRECCIA.getBaseBlock().get(), (Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get(), level, pos);
        }
        return null;
    }

    public static void addMilkshakeInteraction(Fluid fluid, Block stoneBedrock, Block stoneDefault) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, fluidState) -> level.getFluidState(relativePos).is(fluid) && fluidState.isSource(), Blocks.OBSIDIAN.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, fluidState) -> DesiresUtils.randomChance((Integer)DesiresConfigs.server().chanceForOreStone.get(), level) && level.getBlockState(currentPos.below()).is(DesiresTags.BlockTags.ORE_GENERATOR.tag) && level.getFluidState(relativePos).is(fluid) && !fluidState.isSource(), stoneBedrock.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, fluidState) -> DesiresUtils.randomChance((Integer)DesiresConfigs.server().chanceForArtificialOreStone.get(), level) && level.getBlockState(currentPos.below()).is(DesiresTags.BlockTags.ARTIFICIAL_ORE_GENERATOR.tag) && level.getFluidState(relativePos).is(fluid) && !fluidState.isSource(), stoneBedrock.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, fluidState) -> level.getFluidState(relativePos).is(fluid) && !fluidState.isSource(), stoneDefault.defaultBlockState()));
    }

    public static boolean addMilkshakeFlag(FluidState fluidState, Fluid milkshake, Level level, BlockPos pos) {
        boolean validMilkshakePoints = level.getFluidState(pos.relative(Direction.Axis.X, 1)).is(milkshake) || level.getFluidState(pos.relative(Direction.Axis.Y, 1)).is(milkshake) || level.getFluidState(pos.relative(Direction.Axis.Z, 1)).is(milkshake);
        boolean pointIsEmpty = level.getBlockState(pos).isAir() || level.getBlockState(pos).canBeReplaced();
        boolean isValidMilkshake = validMilkshakePoints && pointIsEmpty && !level.getBlockState(pos).liquid();
        return fluidState.getType().isSame(milkshake) || isValidMilkshake;
    }

    public static BlockState addMilkshakeStones(Block stoneBedrock, Block stoneDefault, Level level, BlockPos pos) {
        if (level.getBlockState(pos.below()).is(DesiresTags.BlockTags.ORE_GENERATOR.tag) && DesiresUtils.randomChance((Integer)DesiresConfigs.server().chanceForOreStone.get(), level)) {
            return stoneBedrock.defaultBlockState();
        }
        if (level.getBlockState(pos.below()).is(DesiresTags.BlockTags.ARTIFICIAL_ORE_GENERATOR.tag) && DesiresUtils.randomChance((Integer)DesiresConfigs.server().chanceForArtificialOreStone.get(), level)) {
            return stoneBedrock.defaultBlockState();
        }
        return stoneDefault.defaultBlockState();
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

