/*
 * Decompiled with CFR 0.152.
 */
package elocindev.item_obliterator.neoforge.utils;

import elocindev.item_obliterator.neoforge.ItemObliterator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.trading.MerchantOffer;

public class Utils {
    public static String getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    public static boolean shouldRecipeBeDisabled(Item item) {
        return Utils.shouldRecipeBeDisabled(Utils.getItemId(item));
    }

    public static boolean shouldRecipeBeDisabled(String itemid) {
        if (Utils.isDisabled(itemid)) {
            return true;
        }
        if (!ItemObliterator.Config.use_hashmap_optimizations) {
            for (String blacklisted_id : ItemObliterator.Config.only_disable_recipes) {
                String regex;
                if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
                if (blacklisted_id.equals(itemid)) {
                    return true;
                }
                if (!blacklisted_id.startsWith("!") || !itemid.matches(regex = blacklisted_id.substring(1))) continue;
                return true;
            }
        } else {
            return ItemObliterator.only_disable_recipes.contains(itemid);
        }
        return false;
    }

    public static boolean isDisabled(String itemid) {
        if (itemid.equals("minecraft:air")) {
            return false;
        }
        if (!ItemObliterator.Config.use_hashmap_optimizations) {
            for (String blacklisted_id : ItemObliterator.Config.blacklisted_items) {
                String regex;
                if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
                if (blacklisted_id.equals(itemid)) {
                    return true;
                }
                if (!blacklisted_id.startsWith("!") || !itemid.matches(regex = blacklisted_id.substring(1))) continue;
                return true;
            }
        } else {
            return ItemObliterator.blacklisted_items.contains(itemid);
        }
        return false;
    }

    public static boolean isDisabled(ItemStack stack) {
        CustomData tag;
        if (stack == null || stack.isEmpty() || stack.is(Items.AIR)) {
            return false;
        }
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null) {
            String nbtString = tag.toString();
            for (String blacklisted_nbt : ItemObliterator.Config.blacklisted_nbt) {
                String regex;
                if (blacklisted_nbt == null || blacklisted_nbt.startsWith("//")) continue;
                if (nbtString.contains(blacklisted_nbt)) {
                    return true;
                }
                if (!blacklisted_nbt.startsWith("!") || !nbtString.matches(regex = blacklisted_nbt.substring(1))) continue;
                return true;
            }
        }
        return Utils.isDisabled(Utils.getItemId(stack.getItem()));
    }

    public static boolean isDisabled(MerchantOffer offer) {
        if (Utils.isDisabled(offer.getResult())) {
            return true;
        }
        if (Utils.isDisabled(offer.getBaseCostA())) {
            return true;
        }
        return offer.getCostB() != null && Utils.isDisabled(offer.getCostB());
    }

    public static String getOfferSummary(MerchantOffer offer) {
        String resultId = Utils.getItemId(offer.getResult().getItem());
        String buyAId = Utils.getItemId(offer.getBaseCostA().getItem());
        String buyBId = offer.getCostB() != null ? Utils.getItemId(offer.getCostB().getItem()) : "none";
        return "BuyA: " + buyAId + ", BuyB: " + buyBId + ", Result: " + resultId;
    }

    public static boolean isDisabledInteract(String itemid) {
        for (String blacklisted_id : ItemObliterator.Config.only_disable_interactions) {
            String regex;
            if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
            if (blacklisted_id.equals(itemid)) {
                return true;
            }
            if (!blacklisted_id.startsWith("!") || !itemid.matches(regex = blacklisted_id.substring(1))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisabledInteract(ItemStack stack) {
        return stack != null && Utils.isDisabledInteract(Utils.getItemId(stack.getItem()));
    }

    public static boolean isDisabledAttack(String itemid) {
        for (String blacklisted_id : ItemObliterator.Config.only_disable_attacks) {
            String regex;
            if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
            if (blacklisted_id.equals(itemid)) {
                return true;
            }
            if (!blacklisted_id.startsWith("!") || !itemid.matches(regex = blacklisted_id.substring(1))) continue;
            return true;
        }
        return false;
    }
}

