/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.general;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.JadeAddons;
import snownee.jade.addon.JadeAddonsBase;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.util.JsonConfig;

public class TargetModifierLoader
extends SimpleJsonResourceReloadListener
implements JadeRayTraceCallback,
JadeTooltipCollectedCallback {
    protected final ListMultimap<Object, ResourceLocation> tagsToRemove = ArrayListMultimap.create();
    protected final Map<Object, Block> replacementBlocks = Maps.newHashMap();

    public TargetModifierLoader() {
        super(JsonConfig.GSON, "jade/target_modifier");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.tagsToRemove.clear();
        this.replacementBlocks.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                String type = GsonHelper.getAsString((JsonObject)jsonObject, (String)"type");
                List<?> targets = TargetModifierLoader.parseTargets(GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"target"));
                if ("remove_elements".equals(type)) {
                    JsonElement tagElement = GsonHelper.getNonNull((JsonObject)jsonObject, (String)"tag");
                    List<ResourceLocation> tags = tagElement.isJsonArray() ? tagElement.getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(ResourceLocation::parse).toList() : List.of(ResourceLocation.parse((String)tagElement.getAsString()));
                    for (Object target : targets) {
                        this.tagsToRemove.putAll(target, tags);
                    }
                    continue;
                }
                if ("replace".equals(type)) {
                    JsonObject with = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"with");
                    Block block = TargetModifierLoader.parseBlocks(with).getFirst();
                    for (Object target : targets) {
                        this.replacementBlocks.put(target, block);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            catch (Exception e) {
                if (!IWailaConfig.get().getGeneral().isDebug()) continue;
                JadeAddons.LOGGER.error("Failed to load target modifier {}", (Object)id, (Object)e);
            }
        }
    }

    private static List<?> parseTargets(JsonObject jsonObject) {
        if (jsonObject.has("block") && jsonObject.has("entity")) {
            throw new IllegalArgumentException("Cannot have both block and entity");
        }
        if (jsonObject.has("block")) {
            return TargetModifierLoader.parseBlocks(jsonObject);
        }
        if (jsonObject.has("entity")) {
            return TargetModifierLoader.parseEntities(jsonObject);
        }
        throw new IllegalArgumentException("Must have either block or entity");
    }

    private static List<? extends EntityType<?>> parseEntities(JsonObject jsonObject) {
        String entityId = GsonHelper.getAsString((JsonObject)jsonObject, (String)"entity");
        if (entityId.startsWith("#")) {
            List<EntityType> list = Streams.stream((Iterable)BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)entityId.substring(1))))).map(Holder::value).toList();
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No entity type found for tag: " + entityId));
            return list;
        }
        List list = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)entityId)).map(List::of).orElse(List.of());
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No entity type found for id: " + entityId));
        return list;
    }

    private static List<Block> parseBlocks(JsonObject jsonObject) {
        String blockId = GsonHelper.getAsString((JsonObject)jsonObject, (String)"block");
        if (blockId.startsWith("#")) {
            List<Block> blocks = Streams.stream((Iterable)BuiltInRegistries.BLOCK.getTagOrEmpty(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)blockId.substring(1))))).map(Holder::value).toList();
            Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0, (Object)("No block found for tag: " + blockId));
            return blocks;
        }
        List<Block> list = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)blockId)).map(List::of).orElse(List.of());
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)("No block found for id: " + blockId));
        return list;
    }

    public void reload() {
        Minecraft mc = Minecraft.getInstance();
        Map map = this.prepare(mc.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE);
        this.apply(map, mc.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE);
    }

    @Nullable
    public Accessor<?> onRayTrace(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        Object identifier = TargetModifierLoader.getTargetIdentifier(accessor);
        if (identifier == null) {
            return accessor;
        }
        Block replacement = this.replacementBlocks.get(identifier);
        if (replacement == null) {
            return accessor;
        }
        if (replacement == Blocks.AIR) {
            return null;
        }
        if (accessor == null || accessor.getPlayer().isCreative()) {
            return accessor;
        }
        if (JadeAddonsBase.client.maybeLowVisionUser() || !IWailaConfig.get().getGeneral().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return JadeAddonsBase.client.blockAccessor().from(blockAccessor).blockState(replacement.defaultBlockState()).build();
        }
        if (accessor instanceof EntityAccessor) {
            BlockHitResult blockHitResult = new BlockHitResult(hitResult.getLocation(), accessor.getPlayer().getDirection().getOpposite(), BlockPos.containing((Position)hitResult.getLocation()), false);
            return JadeAddonsBase.client.blockAccessor().hit(blockHitResult).player(accessor.getPlayer()).blockState(replacement.defaultBlockState()).build();
        }
        return accessor;
    }

    public void onTooltipCollected(IBoxElement rootElement, Accessor<?> accessor) {
        Object identifier = TargetModifierLoader.getTargetIdentifier(accessor);
        if (identifier == null) {
            return;
        }
        for (ResourceLocation tag : this.tagsToRemove.get(identifier)) {
            rootElement.getTooltip().remove(tag);
        }
    }

    @Nullable
    public static Object getTargetIdentifier(@Nullable Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return blockAccessor.getBlock();
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return entityAccessor.getEntity().getType();
        }
        return null;
    }
}

