/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.justaraftmod.Reference;
import com.mrbysco.justaraftmod.client.ClientHandler;
import com.mrbysco.justaraftmod.client.RaftModel;
import com.mrbysco.justaraftmod.entities.Raft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class RaftRenderer
extends EntityRenderer<Raft> {
    private static final ResourceLocation DEFAULT_TEXTURE = Reference.modLoc("textures/entity/raft/oak_raft.png");
    private final RaftModel model;

    public RaftRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RaftModel(context.bakeLayer(ClientHandler.RAFT));
        this.shadowRadius = 0.5f;
    }

    public void render(Raft raft, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        float f2;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.375, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)raft.getHurtTime() - partialTicks;
        float f1 = raft.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)raft.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = raft.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.mulPose(new Quaternionf().setAngleAxis(raft.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        this.model.setupAnim(raft, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(this.getTextureLocation(raft)));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)raft, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    public ResourceLocation getTextureLocation(Raft entity) {
        if (entity.getRaftType().getTextureLocation() == null) {
            return DEFAULT_TEXTURE;
        }
        return entity.getRaftType().getTextureLocation();
    }
}

