/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.init;

import com.mrbysco.justaraftmod.entities.Raft;
import com.mrbysco.justaraftmod.init.RaftTypeRegistry;
import com.mrbysco.justaraftmod.items.RaftItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RaftRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"justaraftmod");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"justaraftmod");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"justaraftmod");
    public static final DeferredItem<RaftItem> OAK_RAFT = ITEMS.register("oak_raft", () -> new RaftItem(RaftTypeRegistry.OAK, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> SPRUCE_RAFT = ITEMS.register("spruce_raft", () -> new RaftItem(RaftTypeRegistry.SPRUCE, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> BIRCH_RAFT = ITEMS.register("birch_raft", () -> new RaftItem(RaftTypeRegistry.BIRCH, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> JUNGLE_RAFT = ITEMS.register("jungle_raft", () -> new RaftItem(RaftTypeRegistry.JUNGLE, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> ACACIA_RAFT = ITEMS.register("acacia_raft", () -> new RaftItem(RaftTypeRegistry.ACACIA, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> DARK_OAK_RAFT = ITEMS.register("dark_oak_raft", () -> new RaftItem(RaftTypeRegistry.DARK_OAK, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> BAMBOO_RAFT = ITEMS.register("bamboo_raft", () -> new RaftItem(RaftTypeRegistry.BAMBOO, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> MANGROVE_RAFT = ITEMS.register("mangrove_raft", () -> new RaftItem(RaftTypeRegistry.MANGROVE, RaftRegistry.itemBuilder()));
    public static final DeferredItem<RaftItem> CHERRY_RAFT = ITEMS.register("cherry_raft", () -> new RaftItem(RaftTypeRegistry.CHERRY, RaftRegistry.itemBuilder()));
    public static final Supplier<CreativeModeTab> RAFT_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)OAK_RAFT.get())).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.justaraftmod.raft")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
    }).build());
    public static final Supplier<EntityType<Raft>> RAFT = ENTITIES.register("raft", () -> RaftRegistry.register("raft", EntityType.Builder.of(Raft::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.3f)));

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).build(id);
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties();
    }
}

