/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.entity.Ignis_Fireball_Model;
import com.github.L_Ender.cataclysm.client.render.CMRenderTypes;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Fireball_Entity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class Ignis_Fireball_Renderer
extends EntityRenderer<Ignis_Fireball_Entity> {
    private static final ResourceLocation IGNIS_FIRE_BALL = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/entity/ignis_fireball.png");
    private static final ResourceLocation IGNIS_FIRE_BALL_SOUL = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/entity/ignis_fireball_soul.png");
    private static final ResourceLocation TRAIL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/particle/storm.png");
    public Ignis_Fireball_Model model;
    private final RandomSource random = RandomSource.create();

    public Ignis_Fireball_Renderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.model = new Ignis_Fireball_Model();
    }

    protected int getBlockLightLevel(Ignis_Fireball_Entity entity, BlockPos pos) {
        return 15;
    }

    public void render(Ignis_Fireball_Entity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        float f = this.rotLerp(entityIn.yRotO, entityIn.getYRot(), partialTicks);
        float f1 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        float f2 = (float)entityIn.tickCount + partialTicks;
        matrixStackIn.translate(0.0, (double)0.3f, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f2 * 0.1f)) * 180.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(f2 * 0.1f)) * 180.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(f2 * 0.15f)) * 360.0f));
        this.model.setupAnim((Entity)entityIn, 0.0f, 0.0f, 0.0f, f, f1);
        VertexConsumer VertexConsumer2 = bufferIn.getBuffer(this.model.renderType(this.getTextureLocation(entityIn)));
        this.model.renderToBuffer(matrixStackIn, VertexConsumer2, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        if (entityIn.hasTrail()) {
            double x = Mth.lerp((double)partialTicks, (double)entityIn.xOld, (double)entityIn.getX());
            double y = Mth.lerp((double)partialTicks, (double)entityIn.yOld, (double)entityIn.getY());
            double z = Mth.lerp((double)partialTicks, (double)entityIn.zOld, (double)entityIn.getZ());
            float ran = 0.04f;
            float r = (!entityIn.isSoul() ? 0.8039216f : 0.3254902f) + this.random.nextFloat() * ran;
            float g = (!entityIn.isSoul() ? 0.49411765f : 0.9372549f) + this.random.nextFloat() * ran;
            float b = (!entityIn.isSoul() ? 0.0f : 0.95686275f) + this.random.nextFloat() * ran;
            matrixStackIn.pushPose();
            matrixStackIn.translate(-x, -y, -z);
            this.renderTrail(entityIn, partialTicks, matrixStackIn, bufferIn, r, g, b, 1.0f, packedLightIn);
            matrixStackIn.popPose();
        }
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(Ignis_Fireball_Entity entity) {
        return entity.isSoul() ? IGNIS_FIRE_BALL_SOUL : IGNIS_FIRE_BALL;
    }

    private void renderTrail(Ignis_Fireball_Entity entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn) {
        int sampleSize = 10;
        float trailHeight = 0.2f;
        float trailYRot = 0.0f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3((double)trailHeight, (double)trailHeight, 0.0).yRot(trailYRot).zRot(trailZRot);
        Vec3 bottomAngleVec = new Vec3((double)(-trailHeight), (double)(-trailHeight), 0.0).yRot(trailYRot).zRot(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        PoseStack.Pose lastPose = poseStack.last();
        Matrix4f matrix = lastPose.pose();
        VertexConsumer vertexconsumer = bufferIn.getBuffer(CMRenderTypes.getLightTrailEffect(TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 2, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            this.addVertex(vertexconsumer, matrix, drawFrom, bottomAngleVec, trailR, trailG, trailB, u1, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix, sample, bottomAngleVec, trailR, trailG, trailB, u2, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix, sample, topAngleVec, trailR, trailG, trailB, u2, 0.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix, drawFrom, topAngleVec, trailR, trailG, trailB, u1, 0.0f, packedLightIn);
            drawFrom = sample;
        }
    }

    private void addVertex(VertexConsumer consumer, Matrix4f matrix, Vec3 pos, Vec3 offset, float r, float g, float b, float u, float v, int light) {
        consumer.addVertex(matrix, (float)(pos.x + offset.x), (float)(pos.y + offset.y), (float)(pos.z + offset.z)).setColor(r, g, b, 1.0f).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
    }

    private float rotLerp(float prevRotation, float rotation, float partialTicks) {
        float f;
        for (f = rotation - prevRotation; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevRotation + partialTicks * f;
    }
}

