/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements Errorable {
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @Inject(method={"saveAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at={@At(value="HEAD")})
    private void writeErroredToNbt(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        if (this.neruina$errored) {
            nbt.putBoolean("neruina$errored", true);
        }
        if (this.neruina$tickingEntryId != null) {
            nbt.putUUID("neruina$tickingEntryId", this.neruina$tickingEntryId);
        }
    }

    @Inject(method={"loadAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at={@At(value="TAIL")})
    private void readErroredFromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        if (nbt.contains("neruina$errored")) {
            this.neruina$errored = nbt.getBoolean("neruina$errored");
        }
        if (nbt.contains("neruina$tickingEntryId")) {
            this.neruina$tickingEntryId = nbt.getUUID("neruina$tickingEntryId");
        }
    }
}

