/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.util;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.CrashReportSectionExtender;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.Reflection;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public final class TickingEntry {
    private final Supplier<@Nullable Object> causeSupplier;
    private final boolean persitent;
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    private final Throwable error;
    private final UUID uuid;
    private String cachedCauseType;
    private String cachedCauseName;
    private UUID cachedEntityUuid;
    private final List<String> blacklistedModids = List.of("neruina", "minecraft", "forge", "neoforge");

    public TickingEntry(Object cause, boolean persitent, ResourceKey<Level> dimension, BlockPos pos, Throwable error) {
        this.causeSupplier = () -> cause;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.error = error;
        this.uuid = UUID.randomUUID();
        this.update();
    }

    private TickingEntry(Supplier<@Nullable Object> causeSupplier, boolean persitent, ResourceKey<Level> dimension, BlockPos pos, UUID uuid, Throwable error) {
        this.causeSupplier = causeSupplier;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.uuid = uuid;
        this.error = error;
    }

    public void populate(CrashReportCategory section) {
        section.setDetail("Message", (Object)this.error.getMessage());
        ((CrashReportSectionExtender)section).neruin$setStacktrace(this.error);
        Object cause = this.getCause();
        if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            entity.fillCrashReportCategory(section);
        } else if (cause instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)cause;
            blockEntity.fillCrashReportCategory(section);
        } else if (cause instanceof BlockState) {
            BlockState state = (BlockState)cause;
            section.setDetail("Position", (Object)this.pos);
            section.setDetail("BlockState", (Object)state);
        } else if (cause instanceof ItemStack) {
            ItemStack stack = (ItemStack)cause;
            section.setDetail("ItemStack", (Object)stack);
        } else {
            section.setDetail("Errored", (Object)"Unknown");
        }
    }

    public String createCrashReport() {
        CrashReport report = new CrashReport("Ticking %s".formatted(this.getCauseType()), this.error);
        CrashReportCategory section = report.addCategory("Source: %s".formatted(this.getCauseName()));
        this.populate(section);
        return report.getFriendlyReport(ReportType.CRASH);
    }

    public Object getCause() {
        return this.causeSupplier.get();
    }

    public void update() {
        Object cause = this.causeSupplier.get();
        if (cause instanceof Entity) {
            Entity entity = (Entity)cause;
            this.cachedCauseType = Type.ENTITY.type;
            this.cachedCauseName = Type.ENTITY.nameFunction.apply(entity);
        } else if (cause instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)cause;
            this.cachedCauseType = Type.BLOCK_ENTITY.type;
            this.cachedCauseName = Type.BLOCK_ENTITY.nameFunction.apply(blockEntity);
        } else if (cause instanceof BlockState) {
            BlockState state = (BlockState)cause;
            this.cachedCauseType = Type.BLOCK_STATE.type;
            this.cachedCauseName = Type.BLOCK_STATE.nameFunction.apply(state);
        } else if (cause instanceof ItemStack) {
            ItemStack stack = (ItemStack)cause;
            this.cachedCauseType = Type.ITEM_STACK.type;
            this.cachedCauseName = Type.ITEM_STACK.nameFunction.apply(stack);
        } else {
            this.cachedCauseType = Type.UNKNOWN.type;
            this.cachedCauseName = Type.UNKNOWN.nameFunction.apply(cause);
        }
    }

    public String getCauseType() {
        return this.cachedCauseType;
    }

    public String getCauseName() {
        return this.cachedCauseName;
    }

    public Set<String> findPotentialSources() {
        StackTraceElement[] stackTrace = this.error.getStackTrace();
        HashSet<String> modids = new HashSet<String>();
        for (StackTraceElement element : stackTrace) {
            URL resource;
            String modidFromResource;
            Class<?> clazz;
            try {
                clazz = Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            String methodName = element.getMethodName();
            String modid = this.checkForMixin(clazz, methodName);
            if (modid != null) {
                modids.add(modid);
                continue;
            }
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null || (modidFromResource = TickingEntry.modidFromResource(resource = codeSource.getLocation())) == null) continue;
            modids.add(modidFromResource);
        }
        this.blacklistedModids.forEach(modids::remove);
        return modids;
    }

    @Nullable
    private String checkForMixin(Class<?> clazz, String methodName) {
        Method method = Reflection.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        if (!method.isAnnotationPresent(MixinMerged.class)) {
            return null;
        }
        MixinMerged annotation = method.getAnnotation(MixinMerged.class);
        String mixinClassName = annotation.mixin();
        ClassLoader classLoader = clazz.getClassLoader();
        URL resource = classLoader.getResource(mixinClassName.replace('.', '/') + ".class");
        if (resource == null) {
            return null;
        }
        return TickingEntry.modidFromResource(resource);
    }

    @Nullable
    private static String modidFromResource(URL resource) {
        String location = resource.getPath();
        int index = location.indexOf("jar");
        if (index != -1) {
            location = location.substring(0, index + "jar".length());
            String[] parts = location.split("/");
            String jarName = parts[parts.length - 1];
            return Platform.modidFromJar(jarName);
        }
        return null;
    }

    public CompoundTag writeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("causeType", this.getCauseType());
        nbt.putString("causeName", this.getCauseName());
        nbt.putString("uuid", this.uuid.toString());
        nbt.putString("dimension", this.dimension.location().toString());
        nbt.putLong("pos", this.pos.asLong());
        this.writeStackTraceNbt(nbt);
        try {
            if (this.getCauseType().equals(Type.ENTITY.type)) {
                if (this.cachedEntityUuid != null) {
                    nbt.putUUID("entityUuid", this.cachedEntityUuid);
                } else {
                    Object object = this.getCause();
                    if (object instanceof Entity) {
                        Entity entity = (Entity)object;
                        this.cachedEntityUuid = entity.getUUID();
                        nbt.putUUID("entityUuid", this.cachedEntityUuid);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            Neruina.LOGGER.warn("Failed to find entity UUID when serializing TickingEntry", (Throwable)e);
        }
        return nbt;
    }

    private void writeStackTraceNbt(CompoundTag nbt) {
        nbt.putString("message", this.nonNullString(this.error.getMessage()));
        nbt.putString("exception", this.error.getClass().getName());
        ListTag stacktrace = new ListTag();
        for (StackTraceElement element : this.error.getStackTrace()) {
            CompoundTag elementNbt = new CompoundTag();
            this.writeElementNbt(elementNbt, element);
            stacktrace.add((Object)elementNbt);
        }
        nbt.put("stacktrace", (Tag)stacktrace);
    }

    private void writeElementNbt(CompoundTag elementNbt, StackTraceElement element) {
        elementNbt.putString("classLoaderName", this.nonNullString(element.getClassLoaderName()));
        elementNbt.putString("moduleName", this.nonNullString(element.getModuleName()));
        elementNbt.putString("moduleVersion", this.nonNullString(element.getModuleVersion()));
        elementNbt.putString("declaringClass", this.nonNullString(element.getClassName()));
        elementNbt.putString("methodName", this.nonNullString(element.getMethodName()));
        elementNbt.putString("fileName", this.nonNullString(element.getFileName()));
        elementNbt.putInt("lineNumber", element.getLineNumber());
    }

    private String nonNullString(String str) {
        return str == null ? "" : str;
    }

    public static TickingEntry fromNbt(ServerLevel world, CompoundTag nbtCompound) {
        String causeType = nbtCompound.getString("causeType");
        String causeName = nbtCompound.getString("causeName");
        UUID uuid = nbtCompound.getUUID("uuid");
        String dimensionStr = nbtCompound.getString("dimension");
        ResourceKey dimension = dimensionStr != null ? ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)dimensionStr)) : Level.OVERWORLD;
        BlockPos pos = BlockPos.of((long)nbtCompound.getLong("pos"));
        Throwable error = TickingEntry.readStackTraceNbt(nbtCompound);
        Supplier<Object> cause = () -> null;
        UUID entityUuid = null;
        if (causeType.equals(Type.ENTITY.type)) {
            if (nbtCompound.contains("entityUuid")) {
                UUID finalEntityUuid = entityUuid = nbtCompound.getUUID("entityUuid");
                cause = () -> world.getEntity(finalEntityUuid);
            }
        } else if (causeType.equals(Type.BLOCK_ENTITY.type)) {
            cause = () -> world.getBlockEntity(pos);
        } else if (causeType.equals(Type.BLOCK_STATE.type)) {
            cause = () -> world.getBlockState(pos);
        }
        TickingEntry entry = new TickingEntry(cause, true, (ResourceKey<Level>)dimension, pos, uuid, error);
        entry.cachedCauseType = causeType;
        entry.cachedCauseName = causeName;
        entry.cachedEntityUuid = entityUuid;
        return entry;
    }

    private static Throwable readStackTraceNbt(CompoundTag nbtCompound) {
        String message = nbtCompound.getString("message");
        String exceptionClass = nbtCompound.getString("exception");
        ListTag stacktrace = nbtCompound.getList("stacktrace", 10);
        StackTraceElement[] elements = new StackTraceElement[stacktrace.size()];
        for (int i = 0; i < stacktrace.size(); ++i) {
            String moduleVersion;
            String moduleName;
            Tag nbtElement = stacktrace.get(i);
            CompoundTag compound = (CompoundTag)nbtElement;
            String classLoaderName = compound.getString("classLoaderName");
            if (classLoaderName.isEmpty()) {
                classLoaderName = null;
            }
            if ((moduleName = compound.getString("moduleName")).isEmpty()) {
                moduleName = null;
            }
            if ((moduleVersion = compound.getString("moduleVersion")).isEmpty()) {
                moduleVersion = null;
            }
            String declaringClass = compound.getString("declaringClass");
            String methodName = compound.getString("methodName");
            String fileName = compound.getString("fileName");
            if (fileName.isEmpty()) {
                fileName = null;
            }
            int lineNumber = compound.getInt("lineNumber");
            elements[i] = new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
        }
        return TickingEntry.createThrowable(message, exceptionClass, elements);
    }

    private static Throwable createThrowable(String message, String exceptionClass, StackTraceElement[] elements) {
        try {
            Class<?> clazz = Class.forName(exceptionClass);
            Throwable throwable = (Throwable)clazz.getConstructor(String.class).newInstance(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
        catch (Exception e) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public Throwable error() {
        return this.error;
    }

    public boolean isPersitent() {
        return this.persitent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TickingEntry that = (TickingEntry)obj;
        return Objects.equals(this.cachedCauseName, that.cachedCauseName) && Objects.equals(this.cachedCauseType, that.cachedCauseType) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.pos, that.pos) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    public String toString() {
        return "TickingEntry[causeType=%s, causeName=%s, dimension=%s pos=%s, uuid=%s, error=%s]".formatted(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    private record Type<T>(String type, Function<T, String> nameFunction) {
        static final Type<Entity> ENTITY = new Type<Entity>("Entity", entity -> entity.getName().getString());
        static final Type<BlockEntity> BLOCK_ENTITY = new Type<BlockEntity>("BlockEntity", blockEntity -> blockEntity.getBlockState().getBlock().getName().getString());
        static final Type<BlockState> BLOCK_STATE = new Type<BlockState>("BlockState", blockState -> blockState.getBlock().getName().getString());
        static final Type<ItemStack> ITEM_STACK = new Type<ItemStack>("ItemStack", itemStack -> itemStack.getItem().getDescription().getString());
        static final Type<Object> UNKNOWN = new Type<Object>("Unknown", object -> "Unknown");
    }
}

