/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.datagen;

import com.google.gson.JsonElement;
import dev.shadowsoffire.placebo.datagen.FilteredOrderingFactory;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataProvider;
import org.jetbrains.annotations.Nullable;

public interface FieldOrderingFactory {
    @Nullable
    public Comparator<String> getKeyComparator(JsonElement var1, Path var2);

    public static void register(FieldOrderingFactory factory) {
        Objects.requireNonNull(factory, "Cannot register a null FieldOrderingFactory");
        Impl.FACTORIES.add(factory);
    }

    public static FieldOrderingFactory forType(String objPath, Consumer<Object2IntOpenHashMap<String>> orderBuilder) {
        return FilteredOrderingFactory.builder().forObjectPath(objPath).orderMap(orderBuilder).build();
    }

    public static FieldOrderingFactory forSubtypedObject(String objPath, String type, Consumer<Object2IntOpenHashMap<String>> orderBuilder) {
        return FilteredOrderingFactory.builder().forObjectPath(objPath).forObjectSubtype(type).orderMap(orderBuilder).build();
    }

    public static class Impl {
        private static final List<FieldOrderingFactory> FACTORIES = new ArrayList<FieldOrderingFactory>();

        public static Comparator<String> getComparatorFor(JsonElement json, Path path) {
            for (FieldOrderingFactory factory : FACTORIES) {
                Comparator<String> comparator = factory.getKeyComparator(json, path);
                if (comparator == null) continue;
                return comparator;
            }
            return DataProvider.KEY_COMPARATOR;
        }
    }
}

