/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.hypherionmc.simplerpc.rpcsdk.connection.RPCConnection;
import com.hypherionmc.simplerpc.rpcsdk.enums.DiscordReply;
import com.hypherionmc.simplerpc.rpcsdk.enums.ErrorCode;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.NoDiscordClientException;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.PipeAccessDenied;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.UnsupportedOsType;
import com.hypherionmc.simplerpc.rpcsdk.handlers.DiscordEventHandler;
import com.hypherionmc.simplerpc.rpcsdk.models.DiscordJoinRequest;
import com.hypherionmc.simplerpc.rpcsdk.models.DiscordRichPresence;
import com.hypherionmc.simplerpc.rpcsdk.models.User;
import com.hypherionmc.simplerpc.rpcsdk.utils.Backoff;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordRpc {
    @NotNull
    private Logger logger = LoggerFactory.getLogger(DiscordRpc.class);
    private boolean isDebugMode = false;
    private final boolean disableIoThread;
    private long pid;
    private long nonce;
    private DiscordEventHandler eventHandler;
    private RPCConnection rpcConnection;
    private final Backoff reconnectTimeMs;
    private long nextConnect;
    private String joinGameSecret;
    private String spectateGameSecret;
    private ErrorCode lastErrorCode;
    private String lastErrorMessage;
    private ErrorCode lastDisconnectErrorCode;
    private String lastDisconnectErrorMessage;
    private final AtomicBoolean wasJustConnected;
    private final AtomicReference<User> connectedUser;
    private final AtomicBoolean wasJustDisconnected;
    private final AtomicBoolean gotErrorMessage;
    private final AtomicBoolean wasJoinGame;
    private final AtomicBoolean wasSpectateGame;
    private final AtomicBoolean isFirstConnect;
    private final Queue<byte[]> sendQueue;
    private final Queue<byte[]> presenceQueue;
    private final Queue<DiscordJoinRequest> joinAskQueue;
    private final AtomicBoolean keepRunning;
    private final Lock waitForIoMutex;
    private final Condition waitForIOActivity;
    private Thread ioThread;
    private int reconnectAttempts = 0;

    public DiscordRpc() {
        this(false);
    }

    public DiscordRpc(boolean disableIoThread) {
        this.disableIoThread = disableIoThread;
        this.pid = -1L;
        this.nonce = -1L;
        this.eventHandler = null;
        this.rpcConnection = null;
        this.reconnectTimeMs = new Backoff(1000L, 60000L);
        this.nextConnect = System.currentTimeMillis();
        this.wasJustConnected = new AtomicBoolean(false);
        this.connectedUser = new AtomicReference();
        this.wasJustDisconnected = new AtomicBoolean(false);
        this.gotErrorMessage = new AtomicBoolean(false);
        this.wasJoinGame = new AtomicBoolean(false);
        this.wasSpectateGame = new AtomicBoolean(false);
        this.isFirstConnect = new AtomicBoolean(true);
        this.sendQueue = new ConcurrentLinkedQueue<byte[]>();
        this.presenceQueue = new ConcurrentLinkedQueue<byte[]>();
        this.joinAskQueue = new ConcurrentLinkedQueue<DiscordJoinRequest>();
        this.keepRunning = new AtomicBoolean(true);
        this.waitForIoMutex = new ReentrantLock(true);
        this.waitForIOActivity = this.waitForIoMutex.newCondition();
        this.ioThread = null;
    }

    public void init(@NotNull String applicationId, @Nullable DiscordEventHandler handler, boolean autoRegister) throws UnsupportedOsType, PipeAccessDenied {
        this.init(applicationId, handler, autoRegister, null);
    }

    public void init(@NotNull String applicationId, @Nullable DiscordEventHandler handler, boolean autoRegister, @Nullable String optionalSteamId) throws UnsupportedOsType, PipeAccessDenied {
        if (this.rpcConnection != null) {
            return;
        }
        this.pid = this.getProcessId();
        this.eventHandler = handler;
        this.rpcConnection = RPCConnection.create(applicationId, this);
        if (autoRegister) {
            if (optionalSteamId != null && !optionalSteamId.isEmpty()) {
                this.registerSteamGame(applicationId, optionalSteamId);
            } else {
                this.register(applicationId, null);
            }
        }
        this.rpcConnection.setConnectedCallback(user -> {
            this.wasJustConnected.set(true);
            this.connectedUser.set(user);
            this.isFirstConnect.set(false);
            this.reconnectAttempts = 0;
            if (this.eventHandler != null) {
                this.registerForEvent("ACTIVITY_JOIN");
                this.registerForEvent("ACTIVITY_SPECTATE");
                this.registerForEvent("ACTIVITY_JOIN_REQUEST");
            }
        });
        this.rpcConnection.setDisconnectedCallback((lastErrorCode, lastErrorMessage) -> {
            this.lastDisconnectErrorCode = lastErrorCode;
            this.lastDisconnectErrorMessage = lastErrorMessage;
            this.wasJustDisconnected.set(true);
            this.updateReconnectTime();
        });
        if (!this.disableIoThread) {
            this.keepRunning.set(true);
            this.ioThread = new Thread(() -> {
                try {
                    this.discordRpcIo();
                }
                catch (NoDiscordClientException noDiscordClientException) {
                    // empty catch block
                }
            });
            this.ioThread.start();
        }
    }

    public void shutdown() {
        if (this.rpcConnection == null) {
            return;
        }
        this.rpcConnection.setDisconnectedCallback(null);
        this.rpcConnection.setConnectedCallback(null);
        this.eventHandler = null;
        if (!this.disableIoThread) {
            this.keepRunning.set(false);
            this.signalIoActivity();
            try {
                this.ioThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RPCConnection.destroy(this.rpcConnection);
        this.rpcConnection = null;
    }

    public void updatePresence(@Nullable DiscordRichPresence discordRichPresence) {
        if (discordRichPresence == null) {
            discordRichPresence = DiscordRichPresence.builder().build();
        }
        JsonObject data = discordRichPresence.toJson(this.pid, this.nonce++);
        this.presenceQueue.offer(data.toString().getBytes(StandardCharsets.UTF_8));
        this.signalIoActivity();
    }

    public void respond(User user, DiscordReply reply) {
        if (this.rpcConnection == null || !this.rpcConnection.isOpen()) {
            return;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("cmd", (JsonElement)new JsonPrimitive(reply == DiscordReply.YES ? "SEND_ACTIVITY_JOIN_INVITE" : "CLOSE_ACTIVITY_JOIN_REQUEST"));
        JsonObject args = new JsonObject();
        args.addProperty("user_id", user.getUserId());
        jsonObject.add("args", (JsonElement)args);
        jsonObject.add("nonce", (JsonElement)new JsonPrimitive(String.valueOf(this.nonce++)));
        byte[] bytes = jsonObject.toString().getBytes();
        if (this.sendQueue.offer(bytes)) {
            this.signalIoActivity();
        }
    }

    public void runCallbacks() {
        if (this.rpcConnection == null) {
            return;
        }
        if (this.eventHandler != null) {
            DiscordJoinRequest request;
            boolean wasDisconnected = this.wasJustDisconnected.getAndSet(false);
            boolean isConnected = this.rpcConnection.isOpen();
            if (isConnected && wasDisconnected) {
                this.eventHandler.disconnected(this.lastDisconnectErrorCode, this.lastDisconnectErrorMessage);
            }
            if (this.wasJustConnected.getAndSet(false)) {
                this.eventHandler.ready(this.connectedUser.get());
            }
            if (this.gotErrorMessage.getAndSet(false)) {
                this.eventHandler.errored(this.lastErrorCode, this.lastErrorMessage);
            }
            if (this.wasJoinGame.getAndSet(false)) {
                this.eventHandler.joinGame(this.joinGameSecret);
            }
            if (this.wasSpectateGame.getAndSet(false)) {
                this.eventHandler.spectateGame(this.spectateGameSecret);
            }
            while ((request = this.joinAskQueue.poll()) != null) {
                if (this.eventHandler == null) continue;
                this.eventHandler.joinRequest(request);
            }
            if (!isConnected && wasDisconnected) {
                this.eventHandler.disconnected(this.lastDisconnectErrorCode, this.lastDisconnectErrorMessage);
            }
        }
    }

    public void registerSteamGame(String applicationId, String optionalSteamId) {
        if (this.rpcConnection != null) {
            this.rpcConnection.getBaseConnection().registerSteamGame(applicationId, optionalSteamId);
        }
    }

    public void register(String applicationId, String command) {
        if (this.rpcConnection != null) {
            this.rpcConnection.getBaseConnection().register(applicationId, command);
        }
    }

    private void registerForEvent(String name) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("cmd", (JsonElement)new JsonPrimitive("SUBSCRIBE"));
        jsonObject.add("evt", (JsonElement)new JsonPrimitive(name));
        jsonObject.add("nonce", (JsonElement)new JsonPrimitive(String.valueOf(this.nonce++)));
        byte[] bytes = jsonObject.toString().getBytes();
        if (this.sendQueue.offer(bytes)) {
            this.signalIoActivity();
        }
    }

    private void updateReconnectTime() {
        int maxReconnectAttempts = 10;
        if (this.reconnectAttempts >= maxReconnectAttempts) {
            this.logger.error("Max reconnect attempts reached. Giving up.");
            return;
        }
        long delay = this.reconnectTimeMs.getDelay(this.reconnectAttempts, maxReconnectAttempts);
        this.nextConnect = System.currentTimeMillis() + delay;
        if (this.reconnectAttempts == 0) {
            this.logger.info("Connecting to Discord (Attempt {}/{})", (Object)this.reconnectAttempts, (Object)maxReconnectAttempts);
        } else {
            this.logger.info("Will retry to connect to Discord in {} (Attempt {}/{})", new Object[]{Backoff.formatDuration(delay), this.reconnectAttempts, maxReconnectAttempts});
        }
        ++this.reconnectAttempts;
    }

    private void discordRpcIo() throws NoDiscordClientException, PipeAccessDenied {
        while (this.keepRunning.get()) {
            try {
                this.updateConnection();
            }
            catch (NoDiscordClientException noDiscordClientException) {
                // empty catch block
            }
            this.runCallbacks();
            this.waitForIoMutex.lock();
            try {
                this.waitForIOActivity.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this.waitForIoMutex.unlock();
            }
        }
    }

    private void signalIoActivity() {
        this.waitForIoMutex.lock();
        try {
            this.waitForIOActivity.signalAll();
        }
        catch (Exception exception) {
        }
        finally {
            this.waitForIoMutex.unlock();
        }
    }

    public void updateConnection() throws NoDiscordClientException, PipeAccessDenied {
        block18: {
            byte[] bytes;
            JsonObject message;
            block17: {
                if (this.rpcConnection == null) {
                    return;
                }
                if (this.rpcConnection.isOpen()) break block17;
                if (!this.isFirstConnect.get() && System.currentTimeMillis() < this.nextConnect) break block18;
                this.rpcConnection.open();
                if (this.isFirstConnect.get()) break block18;
                this.updateReconnectTime();
                break block18;
            }
            while (this.rpcConnection.read(message = new JsonObject())) {
                String nonce;
                String evtName = message.has("evt") && !message.get("evt").isJsonNull() ? message.get("evt").getAsString() : null;
                String string = nonce = message.has("nonce") && !message.get("nonce").isJsonNull() ? message.get("nonce").getAsString() : null;
                if (nonce != null) {
                    if (evtName == null || !evtName.equals("ERROR")) continue;
                    JsonObject data = message.get("data").getAsJsonObject();
                    int error = data.get("code").getAsInt();
                    this.lastErrorCode = data.has("code") ? (error >= ErrorCode.values().length ? ErrorCode.UNKNOWN : ErrorCode.values()[error]) : ErrorCode.SUCCESS;
                    this.lastErrorMessage = data.has("message") ? data.get("message").getAsString() : "";
                    this.gotErrorMessage.set(true);
                    continue;
                }
                if (evtName == null) continue;
                switch (evtName) {
                    case "ACTIVITY_JOIN": {
                        String secret;
                        JsonObject data = message.get("data").getAsJsonObject();
                        String string2 = secret = data.has("secret") ? data.get("secret").getAsString() : null;
                        if (secret == null) break;
                        this.joinGameSecret = secret;
                        this.wasJoinGame.set(true);
                        break;
                    }
                    case "ACTIVITY_SPECTATE": {
                        String secret;
                        JsonObject data = message.get("data").getAsJsonObject();
                        String string3 = secret = data.has("secret") ? data.get("secret").getAsString() : null;
                        if (secret == null) break;
                        this.spectateGameSecret = secret;
                        this.wasSpectateGame.set(true);
                        break;
                    }
                    case "ACTIVITY_JOIN_REQUEST": {
                        JsonObject data = message.get("data").getAsJsonObject();
                        JsonObject user = data.get("user").getAsJsonObject();
                        if (user.isJsonNull()) break;
                        DiscordJoinRequest discordJoinRequest = new DiscordJoinRequest((User)new Gson().fromJson((JsonElement)user, User.class));
                        this.joinAskQueue.offer(discordJoinRequest);
                        break;
                    }
                }
            }
            if (!this.presenceQueue.isEmpty()) {
                while ((bytes = this.presenceQueue.peek()) != null && this.rpcConnection.write(bytes)) {
                    this.presenceQueue.poll();
                }
            }
            if (!this.sendQueue.isEmpty()) {
                while ((bytes = this.sendQueue.poll()) != null) {
                    this.rpcConnection.write(bytes);
                }
            }
        }
    }

    private long getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return -1L;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public void printDebug(String message, Object ... objects) {
        if (!this.isDebugMode) {
            return;
        }
        this.getLogger().info("[DEBUG] {}", (Object)String.format(message, objects));
    }

    public void setLogger(@NotNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }
}

