/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.util.rpcavatar;

import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.discord.SimpleRPCCore;
import com.hypherionmc.simplerpc.util.rpcavatar.APIClient;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class RPCImageServer {
    private final File iconsDirectory;
    private final APIClient apiClient;
    private Thread thread;
    private final String imageUrl;
    private final HashMap<String, String> fileMap = new HashMap();
    private boolean isUploading = false;
    public static final RPCImageServer INSTANCE = new RPCImageServer(new File("./config/simple-rpc/icons"), SimpleRPCCore.INSTANCE.getClientConfig().general.rpcImageServerUrl);

    RPCImageServer(File iconsDirectory, String apiUrl) {
        this.apiClient = new APIClient(apiUrl);
        this.imageUrl = apiUrl;
        this.iconsDirectory = iconsDirectory;
        iconsDirectory.mkdirs();
    }

    public void processImages() {
        if (!SimpleRPCCore.INSTANCE.getClientConfig().general.rpcImageServer) {
            return;
        }
        File[] files = this.iconsDirectory.listFiles();
        this.fileMap.clear();
        if (files != null) {
            for (File file : Arrays.stream(files).filter(this::isValidImage).toList()) {
                try {
                    String hash = this.hashFile(file);
                    this.fileMap.put(file.getName(), hash);
                }
                catch (Exception e) {
                    RPCConstants.logger.error("Failed to process image file: {}", (Object)file.getName(), (Object)e);
                }
            }
        }
        Set<String> hashes = this.apiClient.checkHashes(this.fileMap.values());
        List<String> filesToUpload = this.fileMap.entrySet().stream().filter(entry -> !hashes.contains(entry.getValue())).map(Map.Entry::getKey).toList();
        List<File> toUpload = filesToUpload.stream().map(f -> new File(this.iconsDirectory, (String)f)).toList();
        if (!toUpload.isEmpty()) {
            this.isUploading = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread(() -> {
                try {
                    this.apiClient.uploadFiles(toUpload);
                }
                catch (Exception e) {
                    RPCConstants.logger.error("Failed to upload images to RPC Image Server", (Throwable)e);
                }
                this.isUploading = false;
            });
            this.thread.start();
        }
    }

    public String getHash(String fileName) {
        if (this.isUploading) {
            return fileName;
        }
        String hash = this.fileMap.getOrDefault(fileName, fileName);
        return (fileName.endsWith(".gif") || fileName.endsWith(".webp")) && !hash.equalsIgnoreCase(fileName) ? hash + ".gif" : hash;
    }

    private String hashFile(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private boolean isValidImage(File file) {
        try {
            String mime = Files.probeContentType(file.toPath());
            return mime != null && mime.startsWith("image/") && file.length() <= 1000000L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public boolean isUploading() {
        return this.isUploading;
    }
}

