/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.thirstcanteen;

import dev.ghen.thirst.content.registry.ThirstComponent;
import dev.ghen.thirst.foundation.common.event.RegisterThirstValueEvent;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vip.fubuki.thirstcanteen.common.item.Canteen;
import vip.fubuki.thirstcanteen.config.ThirstCanteenConfig;
import vip.fubuki.thirstcanteen.registry.RegistryRecipe;
import vip.fubuki.thirstcanteen.registry.ThirstCanteenItem;

@Mod(value="thirstcanteen")
public class ThirstCanteen {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "thirstcanteen";

    public ThirstCanteen(IEventBus modBus, ModContainer modContainer) {
        ThirstCanteenConfig.setup(modContainer);
        NeoForge.EVENT_BUS.register((Object)this);
        ThirstCanteenItem.ITEMS.register(modBus);
        RegistryRecipe.recipeRegister.register(modBus);
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderItemTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof Canteen) {
            Canteen canteen = (Canteen)item;
            List tooltip = event.getToolTip();
            tooltip.add(Component.translatable((String)"tooltips.drinkable", (Object[])new Object[]{canteen.getLeftUsableTimes(stack), canteen.getMaxUsableTimes()}));
            ThirstCanteen.setPurity(event.getItemStack());
        }
        if (stack.is(ThirstCanteenItem.LEATHER_CANTEEN)) {
            event.getToolTip().add(Component.nullToEmpty((String)"Thanks SquARzY for drawing this."));
        }
    }

    public static void setPurity(ItemStack item) {
        if (item.get(ThirstComponent.PURITY) == null) {
            if (item.is((Item)ThirstCanteenItem.MILITARY_BOTTLE_FULL.get()) || item.is((Item)ThirstCanteenItem.LEATHER_CANTEEN_FULL.get())) {
                item.set(ThirstComponent.PURITY, (Object)0);
            }
            if (item.is((Item)ThirstCanteenItem.DRAGON_BOTTLE_FULL.get())) {
                item.set(ThirstComponent.PURITY, (Object)2);
            }
        }
    }

    @SubscribeEvent
    public void registerDrinks(RegisterThirstValueEvent event) {
        ThirstCanteenItem.ITEMS.getEntries().forEach(itemRegistryObject -> {
            Object patt0$temp = itemRegistryObject.get();
            if (patt0$temp instanceof Canteen) {
                Canteen canteen = (Canteen)patt0$temp;
                event.addDrink((Item)canteen, ((Number)ThirstCanteenConfig.THIRST_RESTORE_EACH_SIP.get()).intValue(), ((Number)ThirstCanteenConfig.QUENCHED_RESTORE_EACH_SIP.get()).intValue());
                event.addContainer((Item)canteen);
            }
        });
    }
}

