/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.thirstcanteen.common.item;

import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import vip.fubuki.thirstcanteen.common.item.Drinkable;

public class Canteen
extends Item
implements Drinkable {
    Supplier<Integer> usableTime;
    Supplier<ItemStack> container;
    Supplier<Integer> defaultPurity;

    public Canteen(Item.Properties properties, Supplier<Integer> usableTime, Supplier<ItemStack> container, Supplier<Integer> defaultPurity) {
        super(properties.stacksTo(1));
        this.usableTime = usableTime;
        this.container = container;
        this.defaultPurity = defaultPurity;
    }

    public Canteen(Item.Properties properties, Supplier<Integer> usableTime, Supplier<ItemStack> container) {
        this(properties.stacksTo(1), usableTime, container, () -> 0);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity user) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack p_42997_) {
        return UseAnim.DRINK;
    }

    @Override
    public int getMaxUsableTimes() {
        return this.usableTime.get();
    }

    @Override
    public int getLeftUsableTimes(ItemStack itemStack) {
        itemStack.getComponents().get(DataComponents.CUSTOM_DATA);
        CustomData customData = (CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = customData != null ? customData.copyTag() : new CompoundTag();
        return compoundTag.getInt("Contain");
    }

    public int getDefaultPurity() {
        return Math.min(this.defaultPurity.get(), 3);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            serverPlayer.gameEvent((Holder)GameEvent.EAT);
            serverPlayer.getFoodData().eat(0, 0.0f);
            Canteen.setContain(itemStack, this.getLeftUsableTimes(itemStack) - 1);
            int times = this.getLeftUsableTimes(itemStack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (times == 0 && !player.getAbilities().instabuild) {
                ItemStack containerStack = new ItemStack((ItemLike)this.container.get().getItem());
                if (containerStack.isEmpty() || !player.getInventory().add(containerStack)) {
                    player.drop(containerStack, false);
                }
                itemStack.shrink(1);
                return itemStack;
            }
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return itemStack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (this.getLeftUsableTimes(stack) == this.getMaxUsableTimes()) {
            player.startUsingItem(interactionHand);
            return InteractionResultHolder.pass((Object)stack);
        }
        boolean handled = false;
        BlockHitResult blockHitResult = Canteen.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockPos = blockHitResult.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        BlockState blockState = level.getBlockState(blockPos);
        int needed = stack.getDamageValue();
        if (level.getFluidState(blockPos).is(FluidTags.WATER)) {
            Canteen.setContain(stack, this.getMaxUsableTimes());
            handled = true;
        } else if (blockEntity != null) {
            IFluidHandler iFluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(level, blockPos, blockState, blockEntity, null);
            if (iFluidHandler != null) {
                int totalAmount = 0;
                int purity = 0;
                for (int i = 0; i < iFluidHandler.getTanks() && iFluidHandler.getFluidInTank(i).getFluid() == Fluids.WATER; ++i) {
                    totalAmount += iFluidHandler.getFluidInTank(i).getAmount();
                    purity = Math.min(purity, WaterPurity.getPurity((FluidStack)iFluidHandler.getFluidInTank(i)));
                }
                int actual = Math.min(needed, totalAmount /= 250);
                if (actual <= 0) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                iFluidHandler.drain(actual * 250, IFluidHandler.FluidAction.EXECUTE);
                Canteen.setContain(stack, Math.min(this.getMaxUsableTimes(), needed + actual));
                WaterPurity.addPurity((ItemStack)stack, (int)Math.min(Math.max(this.getDefaultPurity(), purity), WaterPurity.getPurity((ItemStack)stack)));
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else if (blockState.getBlock() instanceof LayeredCauldronBlock) {
            int waterLevel = (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL);
            int actual = Math.min(needed, waterLevel);
            if (actual <= 0) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (waterLevel - actual > 0) {
                blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(waterLevel - actual));
            } else {
                blockState = Blocks.CAULDRON.defaultBlockState();
            }
            level.setBlockAndUpdate(blockPos, blockState);
            Canteen.setContain(stack, Math.min(this.getMaxUsableTimes(), needed + waterLevel));
            handled = true;
        } else {
            player.startUsingItem(interactionHand);
        }
        if (handled) {
            WaterPurity.addPurity((ItemStack)stack, (int)Math.min(Math.max(this.getDefaultPurity(), WaterPurity.getBlockPurity((Level)level, (BlockPos)blockPos)), WaterPurity.getPurity((ItemStack)stack)));
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
    }

    public static void setContain(ItemStack itemStack, int contain) {
        itemStack.getComponents().get(DataComponents.CUSTOM_DATA);
        CustomData customData = (CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = customData != null ? customData.copyTag() : new CompoundTag();
        compoundTag.putInt("Contain", Math.max(0, contain));
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
    }
}

