/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin;

import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.Bootstrap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Bootstrap.class})
public class MixinBootstrap {
    @Inject(method={"bootStrap"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/cauldron/CauldronInteraction;bootStrap()V", shift=At.Shift.AFTER)})
    private static void modifyCauldronInteractions(CallbackInfo ci) {
        CauldronInteraction.WATER.map().remove(Items.GLASS_BOTTLE);
        CauldronInteraction.WATER.map().put(Items.GLASS_BOTTLE, (blockState, level, pos, player, hand, itemStack) -> {
            if (!level.isClientSide()) {
                Item item = itemStack.getItem();
                ItemStack result = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
                WaterPurity.addPurity(result, pos, level);
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)result));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)pos);
                level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
        CauldronInteraction.WATER.map().remove(Items.BUCKET);
        CauldronInteraction.WATER.map().put(Items.BUCKET, (blockState, level, pos, player, hand, item) -> MixinBootstrap.fillBucket(blockState, level, pos, player, hand, item, WaterPurity.addPurity(new ItemStack((ItemLike)Items.WATER_BUCKET), pos, level), p_175660_ -> (Integer)p_175660_.getValue((Property)LayeredCauldronBlock.LEVEL) == 3, SoundEvents.BUCKET_FILL));
    }

    private static ItemInteractionResult fillBucket(BlockState p_175636_, Level p_175637_, BlockPos p_175638_, Player p_175639_, InteractionHand p_175640_, ItemStack p_175641_, ItemStack p_175642_, Predicate<BlockState> p_175643_, SoundEvent p_175644_) {
        if (!p_175643_.test(p_175636_)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!p_175637_.isClientSide()) {
            Item item = p_175641_.getItem();
            p_175639_.setItemInHand(p_175640_, ItemUtils.createFilledResult((ItemStack)p_175641_, (Player)p_175639_, (ItemStack)p_175642_));
            p_175639_.awardStat(Stats.USE_CAULDRON);
            p_175639_.awardStat(Stats.ITEM_USED.get((Object)item));
            p_175637_.setBlockAndUpdate(p_175638_, Blocks.CAULDRON.defaultBlockState());
            p_175637_.playSound(null, p_175638_, p_175644_, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_175637_.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, p_175638_);
        }
        return ItemInteractionResult.sidedSuccess((boolean)p_175637_.isClientSide);
    }
}

