/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.payload;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageHandlerFull;
import xaero.map.message.payload.WorldMapMessagePayload;
import xaero.map.message.type.WorldMapMessageType;

public class WorldMapMessagePayloadCodec
implements StreamCodec<RegistryFriendlyByteBuf, WorldMapMessagePayload<?>> {
    private final WorldMapMessageHandlerFull messageHandler;

    public WorldMapMessagePayloadCodec(WorldMapMessageHandlerFull messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void encode(RegistryFriendlyByteBuf buf, WorldMapMessagePayload<?> payload) {
        this.messageHandler.encodeMessage(payload.getType(), (WorldMapMessage<?>)payload.getMsg(), (FriendlyByteBuf)buf);
    }

    public WorldMapMessagePayload<?> decode(RegistryFriendlyByteBuf friendlyByteBuf) {
        byte index = friendlyByteBuf.readByte();
        WorldMapMessageType<?> messageType = this.messageHandler.getByIndex(index);
        if (messageType == null) {
            return null;
        }
        return this.createTypedPayload(messageType, (FriendlyByteBuf)friendlyByteBuf);
    }

    private <T extends WorldMapMessage<T>> WorldMapMessagePayload<T> createTypedPayload(WorldMapMessageType<T> messageType, FriendlyByteBuf friendlyByteBuf) {
        return new WorldMapMessagePayload<WorldMapMessage>(messageType, (WorldMapMessage)messageType.getDecoder().apply(friendlyByteBuf));
    }
}

