/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.awesomedungeonocean;

import com.jtorleonstudios.awesomedungeonocean.AwesomeStructure;
import com.jtorleonstudios.awesomedungeonocean.AwsConfig;
import com.jtorleonstudios.awesomedungeonocean.Main;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.jetbrains.annotations.NotNull;

interface AwsOceanBoatStructures {
    public static final MapCodec<Brigantine> CODEC_BRIGANTINE = AwsOceanBoatStructure.getDefaultCodec(10, 80, uniqueResourceLocationStartPool -> AwsConfig.get(uniqueResourceLocationStartPool).isEnabled(), Brigantine::new);
    public static final MapCodec<FrigateL> CODEC_FRIGATE_L = AwsOceanBoatStructure.getDefaultCodec(10, 80, uniqueResourceLocationStartPool -> AwsConfig.get(uniqueResourceLocationStartPool).isEnabled(), FrigateL::new);
    public static final MapCodec<FrigateM> CODEC_FRIGATE_M = AwsOceanBoatStructure.getDefaultCodec(10, 80, uniqueResourceLocationStartPool -> AwsConfig.get(uniqueResourceLocationStartPool).isEnabled(), FrigateM::new);

    public static abstract class AwsOceanBoatStructure
    extends AwesomeStructure {
        private final int offsetSeat;

        public AwsOceanBoatStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, String id, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, int offsetSeat, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
            super(config, startPool, id, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, dimensionPadding, liquidSettings);
            this.offsetSeat = offsetSeat;
        }

        @Override
        protected BlockPos getInitialStartPosition(Structure.GenerationContext ctx) {
            BlockPos bpm = ctx.chunkPos().getMiddleBlockPosition(0);
            return new BlockPos(bpm.getX(), ctx.chunkGenerator().getSeaLevel() - this.offsetSeat, bpm.getZ());
        }

        @Override
        protected boolean canGenerate(Structure.GenerationContext ctx) {
            return AwsOceanBoatStructure.isValidStructureBiome(ctx, 2);
        }
    }

    public static final class FrigateM
    extends AwsOceanBoatStructure {
        public FrigateM(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, String id, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
            super(config, startPool, id, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, 6, dimensionPadding, liquidSettings);
        }

        @NotNull
        public StructureType<?> type() {
            return (StructureType)Main.AWS_FRIGATE_M_TYPE.get();
        }
    }

    public static final class FrigateL
    extends AwsOceanBoatStructure {
        public FrigateL(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, String id, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
            super(config, startPool, id, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, 5, dimensionPadding, liquidSettings);
        }

        @NotNull
        public StructureType<?> type() {
            return (StructureType)Main.AWS_FRIGATE_L_TYPE.get();
        }
    }

    public static final class Brigantine
    extends AwsOceanBoatStructure {
        public Brigantine(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, String id, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
            super(config, startPool, id, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, 3, dimensionPadding, liquidSettings);
        }

        @NotNull
        public StructureType<?> type() {
            return (StructureType)Main.AWS_BRIGANTINE_TYPE.get();
        }
    }
}

